/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.tree.MutableTreeListener;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.MutableTaxonList;
import dr.math.MathUtils;

public interface MutableTree
extends Tree,
MutableTaxonList {
    public boolean beginTreeEdit();

    public void endTreeEdit();

    public void addChild(NodeRef var1, NodeRef var2);

    public void removeChild(NodeRef var1, NodeRef var2);

    public void replaceChild(NodeRef var1, NodeRef var2, NodeRef var3);

    public void setRoot(NodeRef var1);

    public void setNodeHeight(NodeRef var1, double var2);

    public void setNodeRate(NodeRef var1, double var2);

    public void setBranchLength(NodeRef var1, double var2);

    public void setNodeAttribute(NodeRef var1, String var2, Object var3);

    public void addMutableTreeListener(MutableTreeListener var1);

    public static class Utils {
        public static int order(MutableTree mutableTree, NodeRef nodeRef) {
            int n;
            if (mutableTree.isExternal(nodeRef)) {
                return nodeRef.getNumber();
            }
            NodeRef nodeRef2 = mutableTree.getChild(nodeRef, 0);
            NodeRef nodeRef3 = mutableTree.getChild(nodeRef, 1);
            int n2 = Utils.order(mutableTree, nodeRef2);
            if (n2 > (n = Utils.order(mutableTree, nodeRef3))) {
                mutableTree.removeChild(nodeRef, nodeRef2);
                mutableTree.removeChild(nodeRef, nodeRef3);
                mutableTree.addChild(nodeRef, nodeRef3);
                mutableTree.addChild(nodeRef, nodeRef2);
            }
            return Math.min(n2, n);
        }

        public static void scaleNodeHeights(MutableTree mutableTree, double d) {
            NodeRef nodeRef;
            int n;
            for (n = 0; n < mutableTree.getExternalNodeCount(); ++n) {
                nodeRef = mutableTree.getExternalNode(n);
                mutableTree.setNodeHeight(nodeRef, mutableTree.getNodeHeight(nodeRef) * d);
            }
            for (n = 0; n < mutableTree.getInternalNodeCount(); ++n) {
                nodeRef = mutableTree.getInternalNode(n);
                mutableTree.setNodeHeight(nodeRef, mutableTree.getNodeHeight(nodeRef) * d);
            }
        }

        public static void correctHeightsForTips(MutableTree mutableTree) {
            Utils.correctHeightsForTips(mutableTree, mutableTree.getRoot());
        }

        private static void correctHeightsForTips(MutableTree mutableTree, NodeRef nodeRef) {
            double d;
            if (!mutableTree.isExternal(nodeRef)) {
                for (int i = 0; i < mutableTree.getChildCount(nodeRef); ++i) {
                    Utils.correctHeightsForTips(mutableTree, mutableTree.getChild(nodeRef, i));
                }
            }
            if (!mutableTree.isRoot(nodeRef) && (d = mutableTree.getNodeHeight(mutableTree.getParent(nodeRef))) <= mutableTree.getNodeHeight(nodeRef)) {
                double d2 = mutableTree.getNodeHeight(nodeRef);
                mutableTree.setNodeHeight(mutableTree.getParent(nodeRef), d2 += mutableTree.getNodeHeight(mutableTree.getRoot()) * (MathUtils.nextDouble() * 0.001));
            }
        }
    }

    public static class InvalidTreeException
    extends Exception {
        private static final long serialVersionUID = 1955744780140327882L;

        public InvalidTreeException(String string) {
            super(string);
        }
    }
}

