/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.Property;
import dr.evomodel.substmodel.EigenDecomposition;
import dr.evomodel.substmodel.EigenSystem;
import dr.math.matrixAlgebra.RobustEigenDecomposition;
import dr.math.matrixAlgebra.RobustSingularValueDecomposition;
import java.util.Arrays;

public class ColtEigenSystem
implements EigenSystem {
    private boolean checkConditioning;
    private int maxConditionNumber;
    private int maxIterations;
    protected final int stateCount;
    private static final double minProb = Property.DEFAULT.tolerance();
    private static final Algebra alegbra = new Algebra(minProb);
    public static final boolean defaultCheckConditioning = true;
    public static final int defaultMaxConditionNumber = 1000000;
    public static final int defaultMaxIterations = 1000000;

    public ColtEigenSystem(int n) {
        this(n, true, 1000000, 1000000);
    }

    public ColtEigenSystem(int n, boolean bl, int n2, int n3) {
        this.stateCount = n;
        this.checkConditioning = bl;
        this.maxConditionNumber = n2;
        this.maxIterations = n3;
    }

    @Override
    public EigenDecomposition decomposeMatrix(double[][] dArray) {
        DoubleMatrix2D doubleMatrix2D;
        Object object;
        int n = dArray.length;
        RobustEigenDecomposition robustEigenDecomposition = new RobustEigenDecomposition(new DenseDoubleMatrix2D(dArray), this.maxIterations);
        DoubleMatrix2D doubleMatrix2D2 = robustEigenDecomposition.getV();
        if (this.checkConditioning) {
            try {
                object = new RobustSingularValueDecomposition(doubleMatrix2D2, this.maxIterations);
            }
            catch (ArithmeticException arithmeticException) {
                System.err.println(arithmeticException.getMessage());
                return this.getEmptyDecomposition(n);
            }
            if (((RobustSingularValueDecomposition)object).cond() > (double)this.maxConditionNumber) {
                return this.getEmptyDecomposition(n);
            }
        }
        try {
            doubleMatrix2D = alegbra.inverse(doubleMatrix2D2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.getEmptyDecomposition(n);
        }
        object = doubleMatrix2D2.toArray();
        double[][] dArray2 = doubleMatrix2D.toArray();
        double[] dArray3 = this.getAllEigenValues(robustEigenDecomposition);
        if (this.checkConditioning) {
            for (int i = 0; i < dArray3.length; ++i) {
                if (Double.isNaN(dArray3[i]) || Double.isInfinite(dArray3[i])) {
                    return this.getEmptyDecomposition(n);
                }
                if (!(Math.abs(dArray3[i]) < 1.0E-10)) continue;
                dArray3[i] = 0.0;
            }
        }
        double[] dArray4 = new double[n * n];
        double[] dArray5 = new double[n * n];
        for (int i = 0; i < ((Object)object).length; ++i) {
            System.arraycopy(object[i], 0, dArray4, i * n, n);
            System.arraycopy(dArray2[i], 0, dArray5, i * n, n);
        }
        return new EigenDecomposition(dArray4, dArray5, dArray3);
    }

    @Override
    public double computeExponential(EigenDecomposition eigenDecomposition, double d, int n, int n2) {
        if (eigenDecomposition == null) {
            return 0.0;
        }
        double[] dArray = eigenDecomposition.getEigenVectors();
        double[] dArray2 = eigenDecomposition.getEigenValues();
        double[] dArray3 = eigenDecomposition.getInverseEigenVectors();
        double d2 = 0.0;
        for (int i = 0; i < this.stateCount; ++i) {
            d2 += dArray[n * this.stateCount + i] * Math.exp(d * dArray2[i]) * dArray3[i * this.stateCount + n2];
        }
        return Math.abs(d2);
    }

    @Override
    public void computeExponential(EigenDecomposition eigenDecomposition, double d, double[] dArray) {
        int n;
        double d2;
        int n2;
        if (eigenDecomposition == null) {
            Arrays.fill(dArray, 0.0);
            return;
        }
        double[] dArray2 = eigenDecomposition.getEigenVectors();
        double[] dArray3 = eigenDecomposition.getEigenValues();
        double[] dArray4 = eigenDecomposition.getInverseEigenVectors();
        double[][] dArray5 = new double[this.stateCount][this.stateCount];
        for (n2 = 0; n2 < this.stateCount; ++n2) {
            d2 = Math.exp(d * dArray3[n2]);
            for (n = 0; n < this.stateCount; ++n) {
                dArray5[n2][n] = dArray4[n2 * this.stateCount + n] * d2;
            }
        }
        n2 = 0;
        for (n = 0; n < this.stateCount; ++n) {
            for (int i = 0; i < this.stateCount; ++i) {
                d2 = 0.0;
                for (int j = 0; j < this.stateCount; ++j) {
                    d2 += dArray2[n * this.stateCount + j] * dArray5[j][i];
                }
                dArray[n2] = Math.abs(d2);
                ++n2;
            }
        }
    }

    protected double[] getAllEigenValues(RobustEigenDecomposition robustEigenDecomposition) {
        return robustEigenDecomposition.getRealEigenvalues().toArray();
    }

    protected double[] getEmptyAllEigenValues(int n) {
        return new double[n];
    }

    protected EigenDecomposition getEmptyDecomposition(int n) {
        return new EigenDecomposition(new double[n * n], new double[n * n], this.getEmptyAllEigenValues(n));
    }
}

