/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood;

import beagle.Beagle;
import dr.evolution.tree.Tree;
import dr.evomodel.branchmodel.BranchModel;
import dr.evomodel.substmodel.EigenDecomposition;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.evomodel.treedatalikelihood.BufferIndexHelper;
import dr.evomodel.treedatalikelihood.EvolutionaryProcessDelegate;
import dr.evomodel.treedatalikelihood.PreOrderSettings;
import java.io.Serializable;

public final class HomogenousSubstitutionModelDelegate
implements EvolutionaryProcessDelegate,
Serializable {
    private final SubstitutionModel substitutionModel;
    private final int eigenCount = 1;
    private final int nodeCount;
    private final BufferIndexHelper eigenBufferHelper;
    private final BufferIndexHelper matrixBufferHelper;
    private final PreOrderSettings settings;

    public HomogenousSubstitutionModelDelegate(Tree tree, BranchModel branchModel) {
        this(tree, branchModel, 0, PreOrderSettings.getDefault());
    }

    public HomogenousSubstitutionModelDelegate(Tree tree, BranchModel branchModel, int n) {
        this(tree, branchModel, n, PreOrderSettings.getDefault());
    }

    public HomogenousSubstitutionModelDelegate(Tree tree, BranchModel branchModel, int n, PreOrderSettings preOrderSettings) {
        assert (branchModel.getSubstitutionModels().size() == 1) : "this delegate should only be used with simple branch models";
        this.substitutionModel = branchModel.getRootSubstitutionModel();
        this.nodeCount = tree.getNodeCount();
        this.eigenBufferHelper = new BufferIndexHelper(1, 0, n);
        this.matrixBufferHelper = new BufferIndexHelper(this.nodeCount, 0, n);
        this.settings = preOrderSettings;
    }

    public HomogenousSubstitutionModelDelegate(SubstitutionModel substitutionModel, int n) {
        this.substitutionModel = substitutionModel;
        this.eigenBufferHelper = new BufferIndexHelper(1, 0, 1);
        this.matrixBufferHelper = new BufferIndexHelper(n, 0, 1);
        this.nodeCount = 0;
        this.settings = PreOrderSettings.getDefault();
    }

    @Override
    public boolean canReturnComplexDiagonalization() {
        return this.substitutionModel.canReturnComplexDiagonalization();
    }

    @Override
    public int getEigenBufferCount() {
        return this.eigenBufferHelper.getBufferCount();
    }

    @Override
    public int getMatrixBufferCount() {
        return this.matrixBufferHelper.getBufferCount();
    }

    @Override
    public int getInfinitesimalMatrixBufferIndex(int n) {
        return this.matrixBufferHelper.getBufferCount() + this.getEigenIndex(0);
    }

    @Override
    public int getInfinitesimalSquaredMatrixBufferIndex(int n) {
        return this.matrixBufferHelper.getBufferCount() + this.getEigenBufferCount() + this.getEigenIndex(0);
    }

    private int getInfinitesimalMatrixBufferCount(PreOrderSettings preOrderSettings) {
        if (preOrderSettings.branchRateDerivative) {
            return 2 * this.getEigenBufferCount();
        }
        return 0;
    }

    private int getDifferentialMassMatrixBufferCount(PreOrderSettings preOrderSettings) {
        if (preOrderSettings.branchInfinitesimalDerivative) {
            return 2 * (this.nodeCount - 1);
        }
        return 0;
    }

    @Override
    public int getFirstOrderDifferentialMatrixBufferIndex(int n) {
        int n2 = this.matrixBufferHelper.getBufferCount() + this.getInfinitesimalMatrixBufferCount(this.settings) + n;
        return n2;
    }

    @Override
    public int getSecondOrderDifferentialMatrixBufferIndex(int n) {
        return this.getFirstOrderDifferentialMatrixBufferIndex(n) + this.nodeCount - 1;
    }

    @Override
    public void cacheInfinitesimalMatrix(Beagle beagle, int n, double[] dArray) {
        assert (n == 0);
        beagle.setDifferentialMatrix(this.getInfinitesimalMatrixBufferIndex(0), dArray);
    }

    @Override
    public void cacheInfinitesimalSquaredMatrix(Beagle beagle, int n, double[] dArray) {
        assert (n == 0);
        beagle.setDifferentialMatrix(this.getInfinitesimalSquaredMatrixBufferIndex(0), dArray);
    }

    @Override
    public void cacheFirstOrderDifferentialMatrix(Beagle beagle, int n, double[] dArray) {
        beagle.setDifferentialMatrix(this.getFirstOrderDifferentialMatrixBufferIndex(n), dArray);
    }

    @Override
    public int getCachedMatrixBufferCount(PreOrderSettings preOrderSettings) {
        int n = this.getInfinitesimalMatrixBufferCount(preOrderSettings) + this.getDifferentialMassMatrixBufferCount(preOrderSettings);
        return n;
    }

    @Override
    public int getSubstitutionModelCount() {
        return 1;
    }

    @Override
    public SubstitutionModel getSubstitutionModel(int n) {
        assert (n == 0);
        return this.substitutionModel;
    }

    @Override
    public int getEigenIndex(int n) {
        return this.eigenBufferHelper.getOffsetIndex(n);
    }

    @Override
    public int getMatrixIndex(int n) {
        return this.matrixBufferHelper.getOffsetIndex(n);
    }

    @Override
    public double[] getRootStateFrequencies() {
        return this.substitutionModel.getFrequencyModel().getFrequencies();
    }

    @Override
    public void updateSubstitutionModels(Beagle beagle, boolean bl) {
        if (bl) {
            this.eigenBufferHelper.flipOffset(0);
        }
        EigenDecomposition eigenDecomposition = this.substitutionModel.getEigenDecomposition();
        beagle.setEigenDecomposition(this.eigenBufferHelper.getOffsetIndex(0), eigenDecomposition.getEigenVectors(), eigenDecomposition.getInverseEigenVectors(), eigenDecomposition.getEigenValues());
    }

    @Override
    public SubstitutionModel getSubstitutionModelForBranch(int n) {
        return this.substitutionModel;
    }

    @Override
    public void updateTransitionMatrices(Beagle beagle, int[] nArray, double[] dArray, int n, boolean bl) {
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            if (bl) {
                this.matrixBufferHelper.flipOffset(nArray[i]);
            }
            nArray2[i] = this.matrixBufferHelper.getOffsetIndex(nArray[i]);
        }
        beagle.updateTransitionMatrices(this.eigenBufferHelper.getOffsetIndex(0), nArray2, null, null, dArray, n);
    }

    @Override
    public void flipTransitionMatrices(int[] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            this.matrixBufferHelper.flipOffset(nArray[i]);
        }
    }

    @Override
    public void storeState() {
        this.eigenBufferHelper.storeState();
        this.matrixBufferHelper.storeState();
    }

    @Override
    public void restoreState() {
        this.eigenBufferHelper.restoreState();
        this.matrixBufferHelper.restoreState();
    }
}

