/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood;

import beagle.Beagle;
import beagle.BeagleBenchmarkFlag;
import beagle.BeagleFactory;
import beagle.BeagleFlag;
import beagle.BenchmarkedResourceDetails;
import beagle.InstanceDetails;
import beagle.ResourceDetails;
import dr.evolution.alignment.PatternList;
import dr.evolution.datatype.DataType;
import dr.evolution.tree.Tree;
import dr.evolution.util.TaxonList;
import dr.evomodel.branchmodel.BranchModel;
import dr.evomodel.siteratemodel.SiteRateModel;
import dr.evomodel.treedatalikelihood.BeagleFunctionality;
import dr.evomodel.treedatalikelihood.BufferIndexHelper;
import dr.evomodel.treedatalikelihood.DataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.EvolutionaryProcessDelegate;
import dr.evomodel.treedatalikelihood.HomogenousSubstitutionModelDelegate;
import dr.evomodel.treedatalikelihood.ProcessOnTreeDelegate;
import dr.evomodel.treedatalikelihood.RateRescalingScheme;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.TreeTraversal;
import dr.evomodel.treelikelihood.PartialsRescalingScheme;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class MultiPartitionDataLikelihoodDelegate
extends AbstractModel
implements DataLikelihoodDelegate,
Citable {
    private static final boolean COUNT_CALCULATIONS = true;
    private static final boolean RESCALING_OFF = false;
    private static final boolean DEBUG = false;
    private static final String RESOURCE_AUTO_PROPERTY = "beagle.resource.auto";
    private static final String RESOURCE_ORDER_PROPERTY = "beagle.resource.order";
    private static final String PREFERRED_FLAGS_PROPERTY = "beagle.preferred.flags";
    private static final String REQUIRED_FLAGS_PROPERTY = "beagle.required.flags";
    private static final String SCALING_PROPERTY = "beagle.scaling";
    private static final String RESCALE_FREQUENCY_PROPERTY = "beagle.rescale";
    private static final String DELAY_SCALING_PROPERTY = "beagle.delay.scaling";
    private static final String EXTRA_BUFFER_COUNT_PROPERTY = "beagle.extra.buffer.count";
    private static final String FORCE_VECTORIZATION = "beagle.force.vectorization";
    private static final String THREAD_COUNT = "beagle.thread.count";
    private static final PartialsRescalingScheme DEFAULT_RESCALING_SCHEME = PartialsRescalingScheme.DYNAMIC;
    private static int instanceCount = 0;
    private static List<Integer> resourceOrder = null;
    private static List<Integer> preferredOrder = null;
    private static List<Integer> requiredOrder = null;
    private static List<String> scalingOrder = null;
    private static List<Integer> extraBufferOrder = null;
    private static final int RESCALE_FREQUENCY = 100;
    private static final int RESCALE_TIMES = 1;
    private long totalMatrixUpdateCount = 0L;
    private long totalPartialsUpdateCount = 0L;
    private long totalEvaluationCount = 0L;
    private int nodeCount;
    private int tipCount;
    private int internalNodeCount;
    private int[] branchUpdateIndices;
    private double[] branchLengths;
    private int[][] scaleBufferIndices;
    private int[][] storedScaleBufferIndices;
    private int[] operations;
    private boolean[] flip;
    private BufferIndexHelper[] partialBufferHelper;
    private BufferIndexHelper[] scaleBufferHelper;
    private BufferIndexHelper[] categoryRateBufferHelper;
    private PartialsRescalingScheme rescalingScheme;
    private int rescalingFrequency = 100;
    private boolean delayRescalingUntilUnderflow = true;
    private int threadCount = -1;
    private boolean[] useScaleFactors;
    private boolean[] recomputeScaleFactors;
    private boolean[] everUnderflowed;
    private int[] rescalingCount;
    private int[] rescalingCountInner;
    private boolean firstRescaleAttempt;
    private int rescalingMessageCount = 0;
    private boolean[] updatePartition;
    private boolean updateAllPartitions;
    private boolean[] partitionWasUpdated;
    private List<PatternList> patternLists;
    private final DataType dataType;
    private final int partitionCount;
    private final double[] patternWeights;
    private final int[] patternPartitions;
    private final int[] patternCounts;
    private final int totalPatternCount;
    private final int stateCount;
    private final List<BranchModel> branchModels = new ArrayList<BranchModel>();
    private final List<EvolutionaryProcessDelegate> evolutionaryProcessDelegates = new ArrayList<EvolutionaryProcessDelegate>();
    private final List<SiteRateModel> siteRateModels = new ArrayList<SiteRateModel>();
    private final int categoryCount;
    private final Beagle beagle;
    private double[] cachedLogLikelihoodsByPartition;
    private double[] storedCachedLogLikelihoodsByPartition;
    private final boolean[] updateSubstitutionModels;
    private final boolean[] updateSiteRateModels;
    private boolean initialEvaluation = true;

    public static boolean IS_MULTI_PARTITION_RECOMMENDED() {
        int n;
        if (!BeagleFunctionality.IS_MULTI_PARTITION_COMPATIBLE()) {
            return false;
        }
        String string = System.getProperty(RESOURCE_AUTO_PROPERTY);
        if (string != null && Boolean.parseBoolean(string)) {
            return true;
        }
        MultiPartitionDataLikelihoodDelegate.fetchBeagleSettings();
        int n2 = n = resourceOrder.size() > 0 ? instanceCount % resourceOrder.size() : 0;
        if (resourceOrder.size() > 0 && resourceOrder.get(n) > 0) {
            return true;
        }
        if (requiredOrder.size() > 0 && (((long)requiredOrder.get(n).intValue() & BeagleFlag.PROCESSOR_GPU.getMask()) != 0L || ((long)requiredOrder.get(n).intValue() & BeagleFlag.FRAMEWORK_CUDA.getMask()) != 0L || ((long)requiredOrder.get(n).intValue() & BeagleFlag.FRAMEWORK_OPENCL.getMask()) != 0L)) {
            return true;
        }
        return preferredOrder.size() > 0 && (((long)preferredOrder.get(n).intValue() & BeagleFlag.PROCESSOR_GPU.getMask()) != 0L || ((long)preferredOrder.get(n).intValue() & BeagleFlag.FRAMEWORK_CUDA.getMask()) != 0L || ((long)preferredOrder.get(n).intValue() & BeagleFlag.FRAMEWORK_OPENCL.getMask()) != 0L);
    }

    private static void fetchBeagleSettings() {
        if (resourceOrder == null) {
            resourceOrder = BeagleFunctionality.parseSystemPropertyIntegerArray(RESOURCE_ORDER_PROPERTY);
        }
        if (preferredOrder == null) {
            preferredOrder = BeagleFunctionality.parseSystemPropertyIntegerArray(PREFERRED_FLAGS_PROPERTY);
        }
        if (requiredOrder == null) {
            requiredOrder = BeagleFunctionality.parseSystemPropertyIntegerArray(REQUIRED_FLAGS_PROPERTY);
        }
        if (scalingOrder == null) {
            scalingOrder = BeagleFunctionality.parseSystemPropertyStringArray(SCALING_PROPERTY);
        }
        if (extraBufferOrder == null) {
            extraBufferOrder = BeagleFunctionality.parseSystemPropertyIntegerArray(EXTRA_BUFFER_COUNT_PROPERTY);
        }
    }

    /*
     * WARNING - void declaration
     */
    public MultiPartitionDataLikelihoodDelegate(Tree tree, List<PatternList> list, List<BranchModel> list2, List<SiteRateModel> list3, boolean bl, PartialsRescalingScheme partialsRescalingScheme, boolean bl2) throws DataLikelihoodDelegate.DelegateTypeException {
        super("MultiPartitionDataLikelihoodDelegate");
        int n;
        Logger logger = Logger.getLogger("dr.evomodel");
        this.setId(list.get(0).getId());
        this.patternLists = list;
        this.dataType = list.get(0).getDataType();
        this.stateCount = this.dataType.getStateCount();
        this.partitionCount = list.size();
        this.patternCounts = new int[this.partitionCount];
        int n2 = 0;
        int n3 = 0;
        for (PatternList patternList : list) {
            assert (patternList.getDataType().equals(this.dataType));
            this.patternCounts[n3] = patternList.getPatternCount();
            n2 += this.patternCounts[n3];
            ++n3;
        }
        this.totalPatternCount = n2;
        this.useScaleFactors = new boolean[this.partitionCount];
        this.recomputeScaleFactors = new boolean[this.partitionCount];
        this.everUnderflowed = new boolean[this.partitionCount];
        this.flip = new boolean[this.partitionCount];
        for (n = 0; n < this.partitionCount; ++n) {
            this.flip[n] = true;
        }
        this.updatePartition = new boolean[this.partitionCount];
        this.partitionWasUpdated = new boolean[this.partitionCount];
        this.updateAllPartitions = true;
        this.cachedLogLikelihoodsByPartition = new double[this.partitionCount];
        this.storedCachedLogLikelihoodsByPartition = new double[this.partitionCount];
        assert (list2.size() == 1 || list2.size() == list.size());
        this.branchModels.addAll(list2);
        assert (list3.size() == 1 || list3.size() == list.size());
        this.siteRateModels.addAll(list3);
        this.categoryCount = this.siteRateModels.get(0).getCategoryCount();
        this.nodeCount = tree.getNodeCount();
        this.tipCount = tree.getExternalNodeCount();
        this.internalNodeCount = this.nodeCount - this.tipCount;
        this.branchUpdateIndices = new int[this.nodeCount];
        this.branchLengths = new double[this.nodeCount];
        this.scaleBufferIndices = new int[this.partitionCount][this.internalNodeCount];
        this.storedScaleBufferIndices = new int[this.partitionCount][this.internalNodeCount];
        this.operations = new int[this.internalNodeCount * 9 * this.partitionCount];
        this.rescalingCount = new int[this.partitionCount];
        this.rescalingCountInner = new int[this.partitionCount];
        this.firstRescaleAttempt = true;
        try {
            void var32_65;
            void var32_58;
            void var31_50;
            void var32_56;
            int n4;
            int n5;
            String string;
            String string2;
            String string3;
            String string4;
            int n6;
            n = this.tipCount;
            if (bl) {
                n = 0;
            }
            this.partialBufferHelper = new BufferIndexHelper[this.partitionCount];
            this.scaleBufferHelper = new BufferIndexHelper[this.partitionCount];
            this.categoryRateBufferHelper = new BufferIndexHelper[this.partitionCount];
            for (n6 = 0; n6 < this.partitionCount; ++n6) {
                this.partialBufferHelper[n6] = new BufferIndexHelper(this.nodeCount, this.tipCount);
                this.scaleBufferHelper[n6] = new BufferIndexHelper(this.getScaleBufferCount(), 0);
                this.categoryRateBufferHelper[n6] = new BufferIndexHelper(1, 0, n6);
            }
            n6 = 0;
            int n7 = 0;
            int n8 = 0;
            for (BranchModel branchModel : this.branchModels) {
                HomogenousSubstitutionModelDelegate homogenousSubstitutionModelDelegate = new HomogenousSubstitutionModelDelegate(tree, branchModel, n8);
                this.evolutionaryProcessDelegates.add(homogenousSubstitutionModelDelegate);
                n6 += homogenousSubstitutionModelDelegate.getEigenBufferCount();
                n7 += homogenousSubstitutionModelDelegate.getMatrixBufferCount();
                ++n8;
            }
            MultiPartitionDataLikelihoodDelegate.fetchBeagleSettings();
            this.rescalingScheme = partialsRescalingScheme;
            this.delayRescalingUntilUnderflow = bl2;
            Object object2 = null;
            long l = 0L;
            long l2 = 0L;
            if (scalingOrder.size() > 0) {
                this.rescalingScheme = PartialsRescalingScheme.parseFromString(scalingOrder.get(instanceCount % scalingOrder.size()));
            }
            if (resourceOrder.size() > 0 && (object2 = (Object)new int[]{resourceOrder.get(instanceCount % resourceOrder.size()), 0})[0] > 0) {
                l |= BeagleFlag.PROCESSOR_GPU.getMask();
            }
            if (preferredOrder.size() > 0) {
                l = preferredOrder.get(instanceCount % preferredOrder.size()).intValue();
            }
            if (requiredOrder.size() > 0) {
                l2 = requiredOrder.get(instanceCount % requiredOrder.size()).intValue();
            }
            if (this.rescalingScheme == PartialsRescalingScheme.DEFAULT) {
                this.rescalingScheme = object2 != null && object2[0] > true ? DEFAULT_RESCALING_SCHEME : DEFAULT_RESCALING_SCHEME;
            }
            if (this.rescalingScheme == PartialsRescalingScheme.DELAYED) {
                this.delayRescalingUntilUnderflow = true;
                this.rescalingScheme = PartialsRescalingScheme.ALWAYS;
            }
            if (this.rescalingScheme == PartialsRescalingScheme.AUTO) {
                l |= BeagleFlag.SCALING_DYNAMIC.getMask();
            }
            if ((string4 = System.getProperty(RESCALE_FREQUENCY_PROPERTY)) != null) {
                this.rescalingFrequency = Integer.parseInt(string4);
                if (this.rescalingFrequency < 1) {
                    this.rescalingFrequency = 100;
                }
            }
            if ((string3 = System.getProperty(DELAY_SCALING_PROPERTY)) != null) {
                this.delayRescalingUntilUnderflow = Boolean.parseBoolean(string3);
            }
            boolean bl3 = false;
            String string5 = System.getProperty(FORCE_VECTORIZATION);
            if (string5 != null) {
                bl3 = true;
            }
            if ((string2 = System.getProperty(THREAD_COUNT)) != null) {
                this.threadCount = Integer.parseInt(string2);
            }
            if (this.threadCount == 0 || this.threadCount == 1) {
                l &= BeagleFlag.THREADING_CPP.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
                l |= BeagleFlag.THREADING_NONE.getMask();
            } else {
                l &= BeagleFlag.THREADING_NONE.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
                l |= BeagleFlag.THREADING_CPP.getMask();
            }
            if (BeagleFlag.VECTOR_SSE.isSet(l) && this.stateCount != 4 && !bl3 && !BeagleFunctionality.IS_ODD_STATE_SSE_FIXED()) {
                l &= BeagleFlag.VECTOR_SSE.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
                l |= BeagleFlag.VECTOR_NONE.getMask();
                if (this.stateCount > 4 && this.rescalingScheme == PartialsRescalingScheme.DYNAMIC) {
                    this.rescalingScheme = PartialsRescalingScheme.DELAYED;
                }
            }
            if (!BeagleFlag.PRECISION_SINGLE.isSet(l)) {
                l |= BeagleFlag.PRECISION_DOUBLE.getMask();
            }
            if (this.evolutionaryProcessDelegates.get(0).canReturnComplexDiagonalization()) {
                l2 |= BeagleFlag.EIGEN_COMPLEX.getMask();
            }
            if (object2 == null && (BeagleFlag.PROCESSOR_GPU.isSet(l) || BeagleFlag.FRAMEWORK_CUDA.isSet(l) || BeagleFlag.FRAMEWORK_OPENCL.isSet(l)) || object2 != null && object2[0] > 0) {
                l &= BeagleFlag.VECTOR_SSE.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
                l &= BeagleFlag.THREADING_CPP.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((string = System.getProperty(RESOURCE_AUTO_PROPERTY)) != null && Boolean.parseBoolean(string)) {
                long l3 = 0L;
                l3 = this.rescalingScheme == PartialsRescalingScheme.NONE ? BeagleBenchmarkFlag.SCALING_NONE.getMask() : (this.rescalingScheme == PartialsRescalingScheme.ALWAYS ? BeagleBenchmarkFlag.SCALING_ALWAYS.getMask() : BeagleBenchmarkFlag.SCALING_DYNAMIC.getMask());
                logger.info("\nRunning benchmarks to automatically select fastest BEAGLE resource for analysis... ");
                List<BenchmarkedResourceDetails> list4 = BeagleFactory.getBenchmarkedResourceDetails(this.tipCount, n, this.stateCount, this.totalPatternCount, this.categoryCount, (int[])object2, l, l2, 1, this.partitionCount, 0, l3);
                logger.info(" Benchmark results, from fastest to slowest:");
                for (BenchmarkedResourceDetails object3 : list4) {
                    logger.info(object3.toString());
                }
                long l4 = list4.get(0).getBenchedFlags();
                if ((l4 & BeagleFlag.FRAMEWORK_CPU.getMask()) != 0L) {
                    throw new DataLikelihoodDelegate.DelegateTypeException();
                }
                object2 = new int[]{list4.get(0).getResourceNumber()};
            }
            this.beagle = BeagleFactory.loadBeagleInstance(this.tipCount, this.partialBufferHelper[0].getBufferCount(), n, this.stateCount, this.totalPatternCount, n6, n7, this.categoryCount, this.scaleBufferHelper[0].getBufferCount(), (int[])object2, l, l2);
            InstanceDetails instanceDetails = this.beagle.getDetails();
            ResourceDetails resourceDetails = null;
            long l5 = instanceDetails.getFlags();
            if ((l5 & BeagleFlag.FRAMEWORK_CPU.getMask()) != 0L) {
                throw new DataLikelihoodDelegate.DelegateTypeException();
            }
            logger.info("\nUsing Multi-Partition Data Likelihood Delegate with BEAGLE 3 multi-partition extensions");
            for (BranchModel branchModel : this.branchModels) {
                this.addModel(branchModel);
            }
            for (SiteRateModel siteRateModel : this.siteRateModels) {
                assert (siteRateModel.getCategoryCount() == this.categoryCount);
                this.addModel(siteRateModel);
            }
            if (instanceDetails != null) {
                resourceDetails = BeagleFactory.getResourceDetails(instanceDetails.getResourceNumber());
                if (resourceDetails != null) {
                    StringBuilder stringBuilder = new StringBuilder("  Using BEAGLE resource ");
                    stringBuilder.append(resourceDetails.getNumber()).append(": ");
                    stringBuilder.append(resourceDetails.getName()).append("\n");
                    if (resourceDetails.getDescription() != null) {
                        String[] stringArray;
                        String[] stringArray2 = stringArray = resourceDetails.getDescription().split("\\|");
                        n5 = stringArray2.length;
                        for (n4 = 0; n4 < n5; ++n4) {
                            String string6 = stringArray2[n4];
                            if (string6.trim().length() <= 0) continue;
                            stringBuilder.append("    ").append(string6.trim()).append("\n");
                        }
                    }
                    stringBuilder.append("    with instance flags: ").append(instanceDetails.toString());
                    logger.info(stringBuilder.toString());
                } else {
                    logger.info("  Error retrieving BEAGLE resource for instance: " + instanceDetails.toString());
                }
            } else {
                logger.info("  No external BEAGLE resources available, or resource list/requirements not met, using Java implementation");
            }
            if (BeagleFunctionality.IS_THREAD_COUNT_COMPATIBLE() && this.threadCount > 1) {
                this.beagle.setCPUThreadCount(this.threadCount);
            }
            this.patternPartitions = new int[this.totalPatternCount];
            this.patternWeights = new double[this.totalPatternCount];
            boolean bl4 = false;
            n3 = 0;
            for (PatternList patternList : list) {
                void var30_41;
                double[] dArray = patternList.getPatternWeights();
                for (n4 = 0; n4 < patternList.getPatternCount(); ++n4) {
                    this.patternPartitions[n3] = var30_41;
                    this.patternWeights[n3] = dArray[n4];
                    ++n3;
                }
                ++var30_41;
            }
            logger.info("  " + (bl ? "Using" : "Ignoring") + " ambiguities in tree likelihood.");
            String string7 = "" + list.get(0).getPatternCount();
            boolean bl5 = true;
            while (var32_56 < list.size()) {
                String string8 = (String)var31_50 + ", " + list.get((int)var32_56).getPatternCount();
                ++var32_56;
            }
            logger.info("  With " + list.size() + " partitions comprising " + (String)var31_50 + " unique site patterns");
            boolean bl6 = false;
            while (var32_58 < this.tipCount) {
                String string9 = tree.getTaxonId((int)var32_58);
                if (bl) {
                    this.setPartials(this.beagle, list, string9, (int)var32_58);
                } else {
                    this.setStates(this.beagle, list, string9, (int)var32_58);
                }
                ++var32_58;
            }
            this.beagle.setPatternWeights(this.patternWeights);
            this.beagle.setPatternPartitions(this.partitionCount, this.patternPartitions);
            String string10 = "  Using rescaling scheme : " + this.rescalingScheme.getText();
            if (this.rescalingScheme == PartialsRescalingScheme.AUTO) {
                this.rescalingScheme = PartialsRescalingScheme.DYNAMIC;
                String string11 = "  Auto rescaling not supported in BEAGLE v3, using : " + this.rescalingScheme.getText();
            }
            n5 = 0;
            if (this.rescalingScheme == PartialsRescalingScheme.DYNAMIC) {
                void var32_61;
                String string12 = (String)var32_61 + " (rescaling every " + this.rescalingFrequency + " evaluations";
                n5 = 1;
            }
            if (this.delayRescalingUntilUnderflow) {
                void var32_63;
                String string13 = (String)var32_63 + (n5 != 0 ? ", " : "(") + "delay rescaling until first overflow";
                n5 = 1;
            }
            String string14 = (String)var32_65 + (n5 != 0 ? ")" : "");
            logger.info(string14);
            if (this.rescalingScheme == PartialsRescalingScheme.DYNAMIC) {
                for (n4 = 0; n4 < this.partitionCount; ++n4) {
                    this.everUnderflowed[n4] = false;
                }
            }
            this.updateSubstitutionModels = new boolean[list2.size()];
            this.updateSubstitutionModels(new boolean[0]);
            this.updateSiteRateModels = new boolean[list3.size()];
            this.updateSiteRateModels(new boolean[0]);
        }
        catch (TaxonList.MissingTaxonException missingTaxonException) {
            throw new RuntimeException(missingTaxonException.toString());
        }
        ++instanceCount;
    }

    @Override
    public String getReport() {
        return null;
    }

    @Override
    public TreeTraversal.TraversalType getOptimalTraversalType() {
        return TreeTraversal.TraversalType.REVERSE_LEVEL_ORDER;
    }

    public List<PatternList> getPatternLists() {
        return this.patternLists;
    }

    @Override
    public int getTraitCount() {
        return 1;
    }

    @Override
    public int getTraitDim() {
        return this.totalPatternCount;
    }

    @Override
    public RateRescalingScheme getRateRescalingScheme() {
        return RateRescalingScheme.NONE;
    }

    private void updateSubstitutionModels(boolean ... blArray) {
        for (int i = 0; i < this.updateSubstitutionModels.length; ++i) {
            this.updateSubstitutionModels[i] = blArray.length < 1 || blArray[0];
        }
    }

    private void updateSubstitutionModel(BranchModel branchModel) {
        for (int i = 0; i < this.branchModels.size(); ++i) {
            if (this.branchModels.get(i) != branchModel) continue;
            this.updateSubstitutionModels[i] = true;
        }
    }

    private void updateSiteRateModels(boolean ... blArray) {
        for (int i = 0; i < this.updateSiteRateModels.length; ++i) {
            this.updateSiteRateModels[i] = blArray.length < 1 || blArray[0];
        }
    }

    private void updateSiteRateModel(SiteRateModel siteRateModel) {
        for (int i = 0; i < this.siteRateModels.size(); ++i) {
            if (this.siteRateModels.get(i) != siteRateModel) continue;
            this.updateSiteRateModels[i] = true;
        }
    }

    private int getScaleBufferCount() {
        return this.internalNodeCount + 1;
    }

    private final void setPartials(Beagle beagle, List<PatternList> list, String string, int n) throws TaxonList.MissingTaxonException {
        int n2;
        int n3;
        double[] dArray = new double[this.totalPatternCount * this.stateCount * this.categoryCount];
        int n4 = 0;
        for (PatternList patternList : list) {
            n3 = patternList.getTaxonIndex(string);
            if (n3 == -1) {
                throw new TaxonList.MissingTaxonException("Taxon, " + string + ", not found in patternList, " + patternList.getId());
            }
            for (int i = 0; i < patternList.getPatternCount(); ++i) {
                int n5 = patternList.getPatternState(n3, i);
                boolean[] blArray = this.dataType.getStateSet(n5);
                for (int j = 0; j < this.stateCount; ++j) {
                    dArray[n4] = blArray[j] ? 1.0 : 0.0;
                    ++n4;
                }
            }
        }
        int n6 = n2 = this.totalPatternCount * this.stateCount;
        for (n3 = 1; n3 < this.categoryCount; ++n3) {
            System.arraycopy(dArray, 0, dArray, n6, n2);
            n6 += n2;
        }
        beagle.setPartials(n, dArray);
    }

    private final void setStates(Beagle beagle, List<PatternList> list, String string, int n) throws TaxonList.MissingTaxonException {
        int[] nArray = new int[this.totalPatternCount];
        int n2 = 0;
        for (PatternList patternList : list) {
            int n3 = patternList.getTaxonIndex(string);
            if (n3 == -1) {
                throw new TaxonList.MissingTaxonException("Taxon, " + string + ", not found in patternList, " + patternList.getId());
            }
            for (int i = 0; i < patternList.getPatternCount(); ++i) {
                nArray[n2] = patternList.getPatternState(n3, i);
                ++n2;
            }
        }
        beagle.setTipStates(n, nArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double calculateLikelihood(List<ProcessOnTreeDelegate.BranchOperation> list, List<ProcessOnTreeDelegate.NodeOperation> list2, int n) throws DataLikelihoodDelegate.LikelihoodException {
        int n2;
        void var9_35;
        void var9_33;
        void var7_17;
        void var7_15;
        Object[] objectArray;
        int n5;
        boolean bl = false;
        if (!this.initialEvaluation) {
            for (n5 = 0; n5 < this.partitionCount; ++n5) {
                if (this.delayRescalingUntilUnderflow && !this.everUnderflowed[n5]) continue;
                if (this.rescalingScheme == PartialsRescalingScheme.ALWAYS || this.rescalingScheme == PartialsRescalingScheme.DELAYED) {
                    this.useScaleFactors[n5] = true;
                    this.recomputeScaleFactors[n5] = true;
                    continue;
                }
                if (this.rescalingScheme != PartialsRescalingScheme.DYNAMIC) continue;
                this.useScaleFactors[n5] = true;
                if (this.rescalingCount[n5] > this.rescalingFrequency) {
                    this.rescalingCount[n5] = 0;
                    this.rescalingCountInner[n5] = 0;
                }
                if (this.rescalingCountInner[n5] >= 1) continue;
                this.recomputeScaleFactors[n5] = true;
                this.updatePartition[n5] = true;
                int n3 = n5;
                this.rescalingCountInner[n3] = this.rescalingCountInner[n3] + 1;
                bl = true;
            }
            if (bl) {
                throw new DataLikelihoodDelegate.LikelihoodRescalingException();
            }
        }
        n5 = 0;
        for (EvolutionaryProcessDelegate object3 : this.evolutionaryProcessDelegates) {
            if (this.updateSubstitutionModels[n5]) {
                object3.updateSubstitutionModels(this.beagle, this.flip[n5]);
                this.updatePartition[n5] = true;
                this.updateAllPartitions = false;
            }
            ++n5;
        }
        n5 = 0;
        for (SiteRateModel siteRateModel : this.siteRateModels) {
            if (this.updateSiteRateModels[n5]) {
                double[] dArray = siteRateModel.getCategoryRates();
                if (dArray == null) {
                    this.updateSubstitutionModels(false);
                    this.updateSiteRateModels(false);
                    return Double.NEGATIVE_INFINITY;
                }
                if (this.flip[n5]) {
                    this.categoryRateBufferHelper[n5].flipOffset(0);
                }
                this.beagle.setCategoryRatesWithIndex(this.categoryRateBufferHelper[n5].getOffsetIndex(0), dArray);
                this.updatePartition[n5] = true;
                this.updateAllPartitions = false;
            }
            ++n5;
        }
        int n7 = 0;
        for (ProcessOnTreeDelegate.BranchOperation branchOperation : list) {
            this.branchUpdateIndices[n7] = branchOperation.getBranchNumber();
            this.branchLengths[n7] = branchOperation.getBranchLength();
            ++n7;
        }
        if (n7 > 0) {
            int[] nArray = new int[n7 * this.partitionCount];
            int[] nArray2 = new int[n7 * this.partitionCount];
            int[] nArray3 = new int[n7 * this.partitionCount];
            objectArray = new double[n7 * this.partitionCount];
            int n4 = 0;
            int n6 = 0;
            for (EvolutionaryProcessDelegate evolutionaryProcessDelegate : this.evolutionaryProcessDelegates) {
                if (this.updatePartition[n6] || this.updateAllPartitions) {
                    if (this.flip[n6]) {
                        evolutionaryProcessDelegate.flipTransitionMatrices(this.branchUpdateIndices, n7);
                    }
                    for (int i = 0; i < n7; ++i) {
                        nArray[n4] = evolutionaryProcessDelegate.getEigenIndex(0);
                        nArray2[n4] = this.categoryRateBufferHelper[n6].getOffsetIndex(0);
                        nArray3[n4] = evolutionaryProcessDelegate.getMatrixIndex(this.branchUpdateIndices[i]);
                        objectArray[n4] = this.branchLengths[i];
                        ++n4;
                    }
                }
                ++n6;
            }
            this.beagle.updateTransitionMatricesWithMultipleModels(nArray, nArray2, nArray3, null, null, (double[])objectArray, n4);
            this.totalMatrixUpdateCount += (long)n4;
        }
        boolean bl2 = false;
        while (var7_15 < this.partitionCount) {
            if ((this.updatePartition[var7_15] || this.updateAllPartitions) && this.flip[var7_15]) {
                for (ProcessOnTreeDelegate.NodeOperation nodeOperation : list2) {
                    this.partialBufferHelper[var7_15].flipOffset(nodeOperation.getNodeNumber());
                }
            }
            ++var7_15;
        }
        boolean bl3 = false;
        n5 = 0;
        for (ProcessOnTreeDelegate.NodeOperation nodeOperation : list2) {
            int n8;
            int n9;
            int n10 = nodeOperation.getNodeNumber();
            int[] nArray = new int[this.partitionCount];
            int[] nArray4 = new int[this.partitionCount];
            for (n9 = 0; n9 < this.partitionCount; ++n9) {
                if (!this.updatePartition[n9] && !this.updateAllPartitions) continue;
                if (this.useScaleFactors[n9]) {
                    n8 = n10 - this.tipCount;
                    if (this.recomputeScaleFactors[n9]) {
                        this.scaleBufferHelper[n9].flipOffset(n8);
                        this.scaleBufferIndices[n9][n8] = this.scaleBufferHelper[n9].getOffsetIndex(n8);
                        nArray[n9] = this.scaleBufferIndices[n9][n8];
                        nArray4[n9] = -1;
                        continue;
                    }
                    nArray[n9] = -1;
                    nArray4[n9] = this.scaleBufferIndices[n9][n8];
                    continue;
                }
                nArray[n9] = -1;
                nArray4[n9] = -1;
            }
            n9 = this.partitionCount / this.evolutionaryProcessDelegates.size();
            for (n8 = 0; n8 < this.partitionCount; ++n8) {
                if (!this.updatePartition[n8] && !this.updateAllPartitions) continue;
                EvolutionaryProcessDelegate evolutionaryProcessDelegate = this.evolutionaryProcessDelegates.get(n8 / n9);
                this.operations[n5] = this.partialBufferHelper[n8].getOffsetIndex(n10);
                this.operations[n5 + 1] = nArray[n8];
                this.operations[n5 + 2] = nArray4[n8];
                this.operations[n5 + 3] = this.partialBufferHelper[n8].getOffsetIndex(nodeOperation.getLeftChild());
                this.operations[n5 + 4] = evolutionaryProcessDelegate.getMatrixIndex(nodeOperation.getLeftChild());
                this.operations[n5 + 5] = this.partialBufferHelper[n8].getOffsetIndex(nodeOperation.getRightChild());
                this.operations[n5 + 6] = evolutionaryProcessDelegate.getMatrixIndex(nodeOperation.getRightChild());
                this.operations[n5 + 7] = n8;
                this.operations[n5 + 8] = -1;
                n5 += 9;
                ++var7_17;
            }
        }
        this.beagle.updatePartialsByPartition(this.operations, (int)var7_17);
        ++this.totalEvaluationCount;
        this.totalPartialsUpdateCount += (long)var7_17;
        int[] nArray = new int[this.partitionCount];
        boolean bl4 = false;
        while (var9_33 < this.partitionCount) {
            nArray[var9_33] = -1;
            if (this.useScaleFactors[var9_33]) {
                if (this.recomputeScaleFactors[var9_33] && (this.updatePartition[var9_33] || this.updateAllPartitions)) {
                    this.scaleBufferHelper[var9_33].flipOffset(this.internalNodeCount);
                    nArray[var9_33] = this.scaleBufferHelper[var9_33].getOffsetIndex(this.internalNodeCount);
                    this.beagle.resetScaleFactorsByPartition(nArray[var9_33], (int)var9_33);
                    this.beagle.accumulateScaleFactorsByPartition(this.scaleBufferIndices[var9_33], this.internalNodeCount, nArray[var9_33], (int)var9_33);
                } else {
                    nArray[var9_33] = this.scaleBufferHelper[var9_33].getOffsetIndex(this.internalNodeCount);
                }
            }
            ++var9_33;
        }
        boolean bl5 = false;
        while (var9_35 < this.siteRateModels.size()) {
            objectArray = this.siteRateModels.get((int)var9_35).getCategoryProportions();
            this.beagle.setCategoryWeights((int)var9_35, (double[])objectArray);
            double[] dArray = this.evolutionaryProcessDelegates.get((int)var9_35).getRootStateFrequencies();
            this.beagle.setStateFrequencies((int)var9_35, dArray);
            ++var9_35;
        }
        int[] nArray5 = new int[this.partitionCount];
        objectArray = new int[this.partitionCount];
        int[] nArray6 = new int[this.partitionCount];
        int[] nArray7 = new int[this.partitionCount];
        Object object = new double[1];
        double[] dArray = new double[this.partitionCount];
        int n11 = 0;
        for (n2 = 0; n2 < this.partitionCount; ++n2) {
            if (!this.updatePartition[n2] && !this.updateAllPartitions) continue;
            nArray5[n11] = n2;
            objectArray[n11] = this.partialBufferHelper[n2].getOffsetIndex(n);
            nArray6[n11] = n2 % this.siteRateModels.size();
            nArray7[n11] = n2 % this.siteRateModels.size();
            nArray[n11] = nArray[n2];
            ++n11;
        }
        this.beagle.calculateRootLogLikelihoodsByPartition((int[])objectArray, nArray6, nArray7, nArray, nArray5, n11, 1, dArray, (double[])object);
        for (n2 = 0; n2 < n11; ++n2) {
            this.cachedLogLikelihoodsByPartition[nArray5[n2]] = dArray[n2];
            this.updatePartition[nArray5[n2]] = false;
            this.recomputeScaleFactors[nArray5[n2]] = false;
            this.partitionWasUpdated[nArray5[n2]] = true;
        }
        Object object2 = object[0];
        this.updateSubstitutionModels(false);
        this.updateSiteRateModels(false);
        this.updateAllPartitions = true;
        if (Double.isNaN((double)object2) || Double.isInfinite((double)object2)) {
            int n12;
            for (n12 = 0; n12 < n11; ++n12) {
                if (!Double.isNaN(dArray[n12]) && !Double.isInfinite(dArray[n12])) continue;
                this.everUnderflowed[nArray5[n12]] = true;
            }
            if (this.firstRescaleAttempt) {
                if (this.delayRescalingUntilUnderflow || this.rescalingScheme == PartialsRescalingScheme.DELAYED) {
                    if (this.rescalingMessageCount % 1000 == 0) {
                        if (this.rescalingMessageCount > 0) {
                            Logger.getLogger("dr.evomodel").info("Underflow calculating likelihood (" + this.rescalingMessageCount + " messages not shown).");
                        } else {
                            Logger.getLogger("dr.evomodel").info("Underflow calculating likelihood. Attempting a rescaling... (" + this.getId() + ")");
                        }
                    }
                    ++this.rescalingMessageCount;
                }
                for (n12 = 0; n12 < n11; ++n12) {
                    if (!this.delayRescalingUntilUnderflow && this.rescalingScheme != PartialsRescalingScheme.DELAYED || !Double.isNaN(dArray[n12]) && !Double.isInfinite(dArray[n12])) continue;
                    this.useScaleFactors[nArray5[n12]] = true;
                    this.recomputeScaleFactors[nArray5[n12]] = true;
                    this.updatePartition[nArray5[n12]] = true;
                    this.flip[nArray5[n12]] = false;
                    this.updateAllPartitions = false;
                }
                this.firstRescaleAttempt = false;
                throw new DataLikelihoodDelegate.LikelihoodUnderflowException();
            }
            return Double.NEGATIVE_INFINITY;
        }
        for (int i = 0; i < n11; ++i) {
            if (this.partitionWasUpdated[nArray5[i]]) {
                if (!(this.delayRescalingUntilUnderflow && !this.everUnderflowed[nArray5[i]] || this.rescalingScheme != PartialsRescalingScheme.DYNAMIC || this.initialEvaluation)) {
                    int n13 = nArray5[i];
                    this.rescalingCount[n13] = this.rescalingCount[n13] + 1;
                }
                this.partitionWasUpdated[nArray5[i]] = false;
            }
            this.recomputeScaleFactors[nArray5[i]] = false;
            this.flip[nArray5[i]] = true;
        }
        this.firstRescaleAttempt = true;
        this.initialEvaluation = false;
        double d = 0.0;
        for (double d2 : this.cachedLogLikelihoodsByPartition) {
            d += d2;
        }
        return d;
    }

    @Override
    public void makeDirty() {
        this.updateSiteRateModels(new boolean[0]);
        this.updateSubstitutionModels(new boolean[0]);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model instanceof SiteRateModel) {
            this.updateSiteRateModel((SiteRateModel)model);
        } else if (model instanceof BranchModel) {
            this.updateSubstitutionModel((BranchModel)model);
        }
        this.fireModelChanged();
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    public void storeState() {
        for (int i = 0; i < this.partitionCount; ++i) {
            this.partialBufferHelper[i].storeState();
            this.categoryRateBufferHelper[i].storeState();
        }
        for (EvolutionaryProcessDelegate evolutionaryProcessDelegate : this.evolutionaryProcessDelegates) {
            evolutionaryProcessDelegate.storeState();
        }
        for (int i = 0; i < this.partitionCount; ++i) {
            if (this.useScaleFactors[i]) {
                this.scaleBufferHelper[i].storeState();
                System.arraycopy(this.scaleBufferIndices[i], 0, this.storedScaleBufferIndices[i], 0, this.scaleBufferIndices[i].length);
            }
            this.flip[i] = true;
        }
        System.arraycopy(this.cachedLogLikelihoodsByPartition, 0, this.storedCachedLogLikelihoodsByPartition, 0, this.cachedLogLikelihoodsByPartition.length);
    }

    @Override
    public void restoreState() {
        for (int i = 0; i < this.partitionCount; ++i) {
            this.partialBufferHelper[i].restoreState();
            this.categoryRateBufferHelper[i].restoreState();
        }
        for (EvolutionaryProcessDelegate object : this.evolutionaryProcessDelegates) {
            object.restoreState();
        }
        for (int i = 0; i < this.partitionCount; ++i) {
            if (!this.useScaleFactors[i]) continue;
            this.scaleBufferHelper[i].restoreState();
            int[] nArray = this.storedScaleBufferIndices[i];
            this.storedScaleBufferIndices[i] = this.scaleBufferIndices[i];
            this.scaleBufferIndices[i] = nArray;
        }
        double[] dArray = this.cachedLogLikelihoodsByPartition;
        this.cachedLogLikelihoodsByPartition = this.storedCachedLogLikelihoodsByPartition;
        this.storedCachedLogLikelihoodsByPartition = dArray;
    }

    @Override
    public void setCallback(TreeDataLikelihood treeDataLikelihood) {
    }

    @Override
    public void setComputePostOrderStatisticsOnly(boolean bl) {
    }

    @Override
    public boolean providesPostOrderStatisticsOnly() {
        return false;
    }

    @Override
    public int vectorizeNodeOperations(List<ProcessOnTreeDelegate.NodeOperation> list, int[] nArray) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public long getTotalCalculationCount() {
        return this.totalPartialsUpdateCount;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.FRAMEWORK;
    }

    @Override
    public String getDescription() {
        return "BEAGLE likelihood calculation library";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.AYRES_2012_BEAGLE);
    }
}

