/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;
import dr.math.distributions.NormalDistribution;
import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.integration.RombergIntegrator;

public class ReflectedNormalDistribution
implements Distribution {
    double lower;
    double upper;
    double precision;
    double m;
    double sd;
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return ReflectedNormalDistribution.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return ReflectedNormalDistribution.this.lower;
        }

        @Override
        public final double getUpperBound() {
            return ReflectedNormalDistribution.this.upper;
        }
    };

    public ReflectedNormalDistribution(double d, double d2, double d3, double d4, double d5) {
        this.m = d;
        this.sd = d2;
        this.lower = d3;
        this.upper = d4;
        this.precision = d5;
    }

    public double getMean() {
        return this.m;
    }

    public void setMean(double d) {
        this.m = d;
    }

    public double getSD() {
        return this.sd;
    }

    public void setSD(double d) {
        this.sd = d;
    }

    @Override
    public double pdf(double d) {
        double d2;
        if (d < this.lower) {
            return 0.0;
        }
        if (d > this.upper) {
            return 0.0;
        }
        double d3 = d2 = NormalDistribution.pdf(d, this.m, this.sd);
        System.out.println("N(" + d + ",m,sd)=" + d2);
        int n = 1;
        do {
            d2 = d3;
            int n2 = 2 * ((n + 1) / 2);
            int n3 = 2 * (n / 2);
            int n4 = n % 2 == 0 ? -1 : 1;
            double d4 = NormalDistribution.pdf((double)n2 * this.lower - (double)n4 * d - (double)n3 * this.upper, this.m, this.sd);
            double d5 = NormalDistribution.pdf((double)n2 * this.upper - (double)n4 * d - (double)n3 * this.lower, this.m, this.sd);
            d3 = d4 + d5 + d2;
            ++n;
            System.out.println("newPDF=" + d3 + " A=" + n2 + " B=" + n3 + " C=" + n4);
        } while (d3 - d2 > this.precision);
        return d3;
    }

    @Override
    public double logPdf(double d) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double cdf(double d) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double quantile(double d) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double mean() {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double variance() {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    public static void main(String[] stringArray) {
        final ReflectedNormalDistribution reflectedNormalDistribution = new ReflectedNormalDistribution(2.0, 2.0, 1.0, 2.0, 1.0E-6);
        reflectedNormalDistribution.pdf(1.0);
        UnivariateRealFunction univariateRealFunction = new UnivariateRealFunction(){

            @Override
            public double value(double d) throws FunctionEvaluationException {
                return reflectedNormalDistribution.pdf(d);
            }
        };
        RombergIntegrator rombergIntegrator = new RombergIntegrator();
        rombergIntegrator.setAbsoluteAccuracy(1.0E-14);
        rombergIntegrator.setMaximalIterationCount(16);
        try {
            double d = rombergIntegrator.integrate(univariateRealFunction, reflectedNormalDistribution.lower, reflectedNormalDistribution.upper);
            System.out.println("Integrated pdf = " + d);
        }
        catch (ConvergenceException convergenceException) {
        }
        catch (FunctionEvaluationException functionEvaluationException) {
            throw new RuntimeException("I have no idea why I am here.");
        }
    }
}

