/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.coalescent;

import jebl.evolution.coalescent.ConstantPopulation;

public class ExponentialGrowth
extends ConstantPopulation {
    private double r;

    public ExponentialGrowth() {
    }

    public ExponentialGrowth(double N0, double r) {
        super(N0);
        this.r = r;
    }

    public final double getGrowthRate() {
        return this.r;
    }

    public void setGrowthRate(double r) {
        this.r = r;
    }

    public void setDoublingTime(double doublingTime) {
        this.setGrowthRate(Math.log(2.0) / doublingTime);
    }

    public double getDemographic(double t) {
        double r = this.getGrowthRate();
        if (r == 0.0) {
            return this.getN0();
        }
        return this.getN0() * Math.exp(-t * r);
    }

    public double getIntensity(double t) {
        double r = this.getGrowthRate();
        if (r == 0.0) {
            return t / this.getN0();
        }
        return (Math.exp(t * r) - 1.0) / this.getN0() / r;
    }

    public double getInverseIntensity(double x) {
        double r = this.getGrowthRate();
        if (r == 0.0) {
            return this.getN0() * x;
        }
        return Math.log(1.0 + this.getN0() * x * r) / r;
    }

    public int getArgumentCount() {
        return 2;
    }

    public String getArgumentName(int n) {
        if (n == 0) {
            return "N0";
        }
        return "r";
    }

    public double getArgument(int n) {
        if (n == 0) {
            return this.getN0();
        }
        return this.getGrowthRate();
    }

    public void setArgument(int n, double value) {
        if (n == 0) {
            this.setN0(value);
        } else {
            this.setGrowthRate(value);
        }
    }

    public double getLowerBound(int n) {
        return 0.0;
    }

    public double getUpperBound(int n) {
        return Double.POSITIVE_INFINITY;
    }
}

