/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.alignment.Alignment;
import dr.inference.model.Parameter;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.oldevomodel.sitemodel.CategorySampleModel;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CategoryOperator
extends SimpleMCMCOperator {
    public static final String CATEGORY_OPERATOR = "categoryOperator";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule(Parameter.class), new ElementRule(CategorySampleModel.class), new ElementRule(Alignment.class)};

        @Override
        public String getParserName() {
            return CategoryOperator.CATEGORY_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            CategorySampleModel categorySampleModel = (CategorySampleModel)xMLObject.getChild(CategorySampleModel.class);
            Alignment alignment = (Alignment)xMLObject.getChild(Alignment.class);
            double d = xMLObject.getDoubleAttribute("weight");
            return new CategoryOperator(categorySampleModel, alignment.getSiteCount(), parameter, d);
        }

        @Override
        public String getParserDescription() {
            return "An operator on categories of sites.";
        }

        @Override
        public Class getReturnType() {
            return CategoryOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private Parameter categoryParameter;
    private CategorySampleModel siteModel;
    private int categoryCount;
    private int siteCount;

    public CategoryOperator(CategorySampleModel categorySampleModel, int n, Parameter parameter, double d) {
        this.categoryParameter = parameter;
        this.setWeight(d);
        this.siteModel = categorySampleModel;
        this.categoryCount = categorySampleModel.getCategoryCount();
        this.siteCount = n;
    }

    @Override
    public final double doOperation() {
        int n;
        int n2 = (int)(MathUtils.nextDouble() * (double)this.siteCount);
        int n3 = (int)this.categoryParameter.getParameterValue(n2);
        this.siteModel.subtractSitesInCategoryCount(n3);
        int[] nArray = new int[this.categoryCount - 1];
        int n4 = 0;
        for (n = 0; n < this.categoryCount; ++n) {
            if (n == n3) continue;
            nArray[n4] = n;
            ++n4;
        }
        n = nArray[(int)(MathUtils.nextDouble() * (double)nArray.length)];
        this.categoryParameter.setParameterValue(n2, n);
        this.siteModel.addSitesInCategoryCount(n);
        return 0.0;
    }

    @Override
    public final String getOperatorName() {
        return CATEGORY_OPERATOR;
    }

    public Element createOperatorElement(Document document) {
        throw new RuntimeException("Not implemented!");
    }

    public String toString() {
        return this.getOperatorName();
    }

    public String getPerformanceSuggestion() {
        return "";
    }
}

