/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous.cdi;

public enum PrecisionType {
    ELEMENTARY("elementary data vector", "elementary", 0){

        @Override
        public void fillPrecisionInPartials(double[] dArray, int n, int n2, double d, int n3) {
            dArray[n + n3] = d;
        }

        @Override
        public void fillEffDimInPartials(double[] dArray, int n, int n2, int n3) {
        }

        @Override
        public void copyObservation(double[] dArray, int n, double[] dArray2, int n2, int n3) {
            dArray2[n2] = dArray[n];
        }

        @Override
        public int getPrecisionOffset(int n) {
            return n;
        }

        @Override
        public int getVarianceOffset(int n) {
            return -1;
        }

        @Override
        public int getEffectiveDimensionOffset(int n) {
            return -1;
        }

        @Override
        public double[] getScaledPrecision(double[] dArray, int n, double[] dArray2, int n2) {
            double d = dArray[n + this.getPrecisionOffset(n2)];
            return PrecisionType.scale(dArray2, d);
        }
    }
    ,
    SCALAR("proportional scaling per branch", "scalar", 0){

        @Override
        public void fillPrecisionInPartials(double[] dArray, int n, int n2, double d, int n3) {
            if (n2 == 0) {
                dArray[n + n3] = d;
            } else if (dArray[n + n3] != 0.0) {
                dArray[n + n3] = d;
            }
        }

        @Override
        public void fillEffDimInPartials(double[] dArray, int n, int n2, int n3) {
        }

        @Override
        public void copyObservation(double[] dArray, int n, double[] dArray2, int n2, int n3) {
            for (int i = 0; i < n3; ++i) {
                dArray2[n2 + i] = Double.isInfinite(dArray[n + n3]) ? dArray[n + i] : Double.NaN;
            }
        }

        @Override
        public int getPrecisionOffset(int n) {
            return n;
        }

        @Override
        public int getVarianceOffset(int n) {
            return -1;
        }

        @Override
        public int getEffectiveDimensionOffset(int n) {
            return -1;
        }

        @Override
        public double[] getScaledPrecision(double[] dArray, int n, double[] dArray2, int n2) {
            double d = dArray[n + this.getPrecisionOffset(n2)];
            return PrecisionType.scale(dArray2, d);
        }
    }
    ,
    MIXED("mixed method", "mixed", 1){

        @Override
        public void fillPrecisionInPartials(double[] dArray, int n, int n2, double d, int n3) {
            dArray[n + n3 + n2] = d;
        }

        @Override
        public void fillEffDimInPartials(double[] dArray, int n, int n2, int n3) {
        }

        @Override
        public void copyObservation(double[] dArray, int n, double[] dArray2, int n2, int n3) {
            for (int i = 0; i < n3; ++i) {
                dArray2[n2 + i] = Double.isInfinite(dArray[n + n3 + i]) ? dArray[n + i] : Double.NaN;
            }
        }

        @Override
        public int getPrecisionOffset(int n) {
            return n;
        }

        @Override
        public int getVarianceOffset(int n) {
            return -1;
        }

        @Override
        public int getEffectiveDimensionOffset(int n) {
            return -1;
        }

        @Override
        public double[] getScaledPrecision(double[] dArray, int n, double[] dArray2, int n2) {
            throw new RuntimeException("Not yet implemented");
        }
    }
    ,
    FULL("full precision matrix per branch", "full", 2){

        @Override
        public void fillPrecisionInPartials(double[] dArray, int n, int n2, double d, int n3) {
            int n4 = n + n3 + n2 * n3 + n2;
            dArray[n4] = d;
            dArray[n4 + n3 * n3] = Double.isInfinite(d) ? 0.0 : 1.0 / d;
            dArray[n + n3 + 2 * n3 * n3] = Double.POSITIVE_INFINITY;
        }

        @Override
        public void fillEffDimInPartials(double[] dArray, int n, int n2, int n3) {
            int n4 = this.getEffectiveDimensionOffset(n3);
            dArray[n + n4] = n2;
        }

        @Override
        public void fillDeterminantInPartials(double[] dArray, int n, double d, int n2) {
            int n3 = this.getDeterminantOffset(n2);
            dArray[n + n3] = d;
        }

        @Override
        public void fillNoDeterminantInPartials(double[] dArray, int n, int n2) {
            this.fillDeterminantInPartials(dArray, n, Double.NaN, n2);
        }

        @Override
        public void fillRemainderInPartials(double[] dArray, int n, double d, int n2) {
            int n3 = this.getRemainderOffset(n2);
            dArray[n + n3] = d;
        }

        @Override
        public void copyObservation(double[] dArray, int n, double[] dArray2, int n2, int n3) {
            for (int i = 0; i < n3; ++i) {
                dArray2[n2 + i] = Double.isInfinite(dArray[n + n3 + i * n3 + i]) ? dArray[n + i] : Double.NaN;
            }
        }

        @Override
        public int getPrecisionLength(int n) {
            return super.getMatrixLength(n);
        }

        @Override
        public int getVarianceLength(int n) {
            return super.getMatrixLength(n);
        }

        @Override
        public int getPrecisionOffset(int n) {
            return n;
        }

        @Override
        public int getEffectiveDimensionOffset(int n) {
            return n + n * n * 2 + 1;
        }

        @Override
        public int getDeterminantOffset(int n) {
            return n + n * n * 2 + 2;
        }

        @Override
        public int getRemainderOffset(int n) {
            return n + n * n * 2 + 3;
        }

        @Override
        public int getVarianceOffset(int n) {
            return n + n * n;
        }

        @Override
        public double[] getScaledPrecision(double[] dArray, int n, double[] dArray2, int n2) {
            double[] dArray3 = new double[n2 * n2];
            System.arraycopy(dArray, n + this.getPrecisionOffset(n2), dArray3, 0, n2 * n2);
            return dArray3;
        }

        @Override
        public boolean hasEffectiveDimension() {
            return true;
        }

        @Override
        public boolean hasDeterminant() {
            return true;
        }

        @Override
        public boolean hasRemainder() {
            return true;
        }

        @Override
        public int getPartialsDimension(int n) {
            return n + 2 * this.getMatrixLength(n) + 4;
        }
    };

    private final int power;
    private final String name;
    private final String tag;

    private PrecisionType(String string2, String string3, int n2) {
        this.name = string2;
        this.tag = string3;
        this.power = n2;
    }

    public String toString() {
        return this.name;
    }

    public int getPower() {
        return this.power;
    }

    protected int getMatrixLength(int n) {
        int n2 = 1;
        int n3 = this.getPower();
        for (int i = 0; i < n3; ++i) {
            n2 *= n;
        }
        return n2;
    }

    public int getPrecisionLength(int n) {
        return this.getMatrixLength(n);
    }

    public int getVarianceLength(int n) {
        return 0;
    }

    public static double getObservedPrecisionValue(boolean bl) {
        return bl ? 0.0 : Double.POSITIVE_INFINITY;
    }

    public abstract void fillPrecisionInPartials(double[] var1, int var2, int var3, double var4, int var6);

    public abstract void fillEffDimInPartials(double[] var1, int var2, int var3, int var4);

    public void fillDeterminantInPartials(double[] dArray, int n, double d, int n2) {
    }

    public void fillNoDeterminantInPartials(double[] dArray, int n, int n2) {
    }

    public boolean isMissingDeterminantValue(double d) {
        return Double.isNaN(d);
    }

    public double getMissingDeterminantValue() {
        return Double.NaN;
    }

    public abstract void copyObservation(double[] var1, int var2, double[] var3, int var4, int var5);

    public int getMeanOffset(int n) {
        return 0;
    }

    public abstract int getPrecisionOffset(int var1);

    public abstract int getVarianceOffset(int var1);

    public abstract int getEffectiveDimensionOffset(int var1);

    public int getDeterminantOffset(int n) {
        return -1;
    }

    public int getRemainderOffset(int n) {
        return -1;
    }

    public void fillRemainderInPartials(double[] dArray, int n, double d, int n2) {
        throw new RuntimeException("precision type " + this.tag + " does not store remainders");
    }

    public abstract double[] getScaledPrecision(double[] var1, int var2, double[] var3, int var4);

    public int getPartialsDimension(int n) {
        return this.getMatrixLength(n) + n;
    }

    public boolean hasEffectiveDimension() {
        return false;
    }

    public boolean hasDeterminant() {
        return false;
    }

    public boolean hasRemainder() {
        return false;
    }

    private static double[] scale(double[] dArray, double d) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = d * dArray[i];
        }
        return dArray2;
    }

    public String getTag() {
        return this.tag;
    }
}

