/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import jebl.evolution.align.Align;
import jebl.evolution.align.AlignAffine;
import jebl.evolution.align.AlignRepeat;
import jebl.evolution.align.AlignRepeatAffine;
import jebl.evolution.align.AlignSimple;
import jebl.evolution.align.NeedlemanWunsch;
import jebl.evolution.align.NeedlemanWunschAffine;
import jebl.evolution.align.NeedlemanWunschLinearSpace;
import jebl.evolution.align.NeedlemanWunschLinearSpaceAffine;
import jebl.evolution.align.NonOverlapMultipleLocalAffine;
import jebl.evolution.align.OverlapAlign;
import jebl.evolution.align.SequenceShuffler;
import jebl.evolution.align.SmithWaterman;
import jebl.evolution.align.SmithWatermanLinearSpace;
import jebl.evolution.align.SmithWatermanLinearSpaceAffine;
import jebl.evolution.align.scores.Scores;
import jebl.evolution.align.scores.ScoresFactory;

public class AlignCommand {
    private boolean relaunch = true;
    private static BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

    public AlignCommand() {
        System.out.println("Usage: AlignCommand <sequence1 file name> <sequence2 file name>\n(FASTA format files)");
    }

    public AlignCommand(String sq1File, String sq2File) {
        String sq1 = "";
        String sq2 = "";
        try {
            BufferedReader br1 = new BufferedReader(new FileReader(sq1File));
            BufferedReader br2 = new BufferedReader(new FileReader(sq2File));
            String line = br1.readLine();
            if (!line.substring(0, 1).equals(">")) {
                sq1 = sq1 + line;
            }
            line = br1.readLine();
            while (line != null && !line.substring(0, 1).equals(">")) {
                sq1 = sq1.concat(line.trim());
                line = br1.readLine();
            }
            line = br2.readLine();
            if (!line.substring(0, 1).equals(">")) {
                sq2 = sq2 + line;
            }
            line = br2.readLine();
            while (line != null && !line.substring(0, 1).equals(">")) {
                sq2 = sq2.concat(line.trim());
                line = br2.readLine();
            }
        }
        catch (Exception e) {
            System.out.println("error reading from sequence file\n" + e);
        }
        while (this.relaunch) {
            this.command(sq1, sq2);
        }
    }

    private void command(String sq1, String sq2) {
        float dist;
        String subVal;
        String subType;
        int threshold;
        float gapExtend;
        float gapOpen;
        NonOverlapMultipleLocalAffine ara;
        Align ar;
        AlignAffine aa;
        AlignSimple as;
        block55: {
            System.out.println("Choose algorithm:");
            System.out.println("1.NeedlemanWunsch");
            System.out.println("2.NeedlemanWunschAffine");
            System.out.println("3.NeedlemanWunschLinearSpace");
            System.out.println("4.OverlapAlign");
            System.out.println("5.RepeatAlign");
            System.out.println("6.SmithWaterman");
            System.out.println("7.SmithWatermanLinearSpace");
            System.out.println("8.SmithWatermanLinearSpaceAffine");
            System.out.println("9.NonOverlapMultipleAlign");
            System.out.println("10.NeedlemanWunschLinearSpaceAffine");
            int input = 0;
            try {
                input = Integer.parseInt(this.readInput("? "));
                if (input < 1 || input > 10) {
                    throw new Exception("must be 1 to 10");
                }
            }
            catch (Exception e) {
                System.out.println("invalid entry\n" + e);
                System.exit(-1);
            }
            as = null;
            aa = null;
            ar = null;
            ara = null;
            switch (input) {
                case 1: {
                    as = new NeedlemanWunsch(null, 0.0f);
                    break;
                }
                case 2: {
                    aa = new NeedlemanWunschAffine(null, 0.0f, 0.0f);
                    break;
                }
                case 3: {
                    as = new NeedlemanWunschLinearSpace(null, 0.0f);
                    break;
                }
                case 4: {
                    as = new OverlapAlign(null, 0.0f);
                    break;
                }
                case 6: {
                    as = new SmithWaterman(null, 0.0f);
                    break;
                }
                case 7: {
                    as = new SmithWatermanLinearSpace(null, 0.0f);
                    break;
                }
                case 8: {
                    aa = new SmithWatermanLinearSpaceAffine(null, 0.0f, 0.0f);
                    break;
                }
                case 9: {
                    ara = new NonOverlapMultipleLocalAffine(null, 0.0f, 0.0f, 0);
                    break;
                }
                case 10: {
                    aa = new NeedlemanWunschLinearSpaceAffine(null, 0.0f, 0.0f);
                }
            }
            System.out.println("Enter gap open penalty:");
            gapOpen = 0.0f;
            try {
                gapOpen = Float.parseFloat(this.readInput("? "));
            }
            catch (Exception e) {
                System.out.println("invalid entry\n" + e);
                System.exit(-1);
            }
            gapExtend = 0.0f;
            if (aa != null || ara != null) {
                System.out.println("Enter gap extend penalty:");
                try {
                    gapExtend = Float.parseFloat(this.readInput("? "));
                }
                catch (Exception e) {
                    System.out.println("invalid entry\n" + e);
                    System.exit(-1);
                }
            }
            threshold = 0;
            if (ar != null || ara != null) {
                System.out.println("Enter threshold T:");
                try {
                    threshold = Integer.parseInt(this.readInput("? "));
                }
                catch (Exception e) {
                    System.out.println("invalid entry\n" + e);
                    System.exit(-1);
                }
            }
            System.out.println("Enter substitution matrix type(1.BLOSUM, 2.PAM, 3.JUKESCANTOR):");
            subType = null;
            subVal = null;
            dist = 0.0f;
            try {
                subType = this.readInput("? ");
                if (subType.equals("BLOSUM") || subType.equals("1")) {
                    System.out.println("Enter BLOSUM value(45 - 90):");
                    subVal = this.readInput("? ");
                    subType = "Blosum";
                    break block55;
                }
                if (subType.equals("PAM") || subType.equals("2")) {
                    System.out.println("Enter PAM value(100 - 250):");
                    subVal = this.readInput("? ");
                    subType = "Pam";
                    break block55;
                }
                if (subType.equals("JUKESCANTOR") || subType.equals("3")) {
                    System.out.println("Enter evolutionary distance d:");
                    dist = Float.parseFloat(this.readInput("? "));
                    subType = "JukesCantor";
                    break block55;
                }
                throw new Exception("must be 1 to 3");
            }
            catch (Exception e) {
                System.out.println("invalid entry\n" + e);
                System.exit(-1);
            }
        }
        Scores sub = subVal != null ? ScoresFactory.generateScores(subType + subVal) : ScoresFactory.generateScores(subType + dist);
        boolean shuffle = false;
        int numShuffles = 0;
        int numRepeats = 1;
        try {
            System.out.println("Do you wish to perform shuffling for the alignment(y/n):");
            String shuff = this.readInput("? ");
            if (shuff.toLowerCase().equals("y")) {
                System.out.println("How many times do you wish to shuffle:");
                numShuffles = Integer.parseInt(this.readInput("? "));
                shuffle = true;
            } else {
                System.out.println("How many times do you wish to run the alignment:");
                numRepeats = Integer.parseInt(this.readInput("? "));
                if (numRepeats < 1) {
                    System.out.println("Must run atleast once, exiting..");
                    System.exit(-1);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String outPut = "";
        if (!shuffle) {
            float score;
            String algoName;
            String match;
            long fin;
            int i;
            long start;
            if (as != null) {
                start = System.currentTimeMillis();
                for (i = 0; i < numRepeats; ++i) {
                    as.setGapOpen(gapOpen);
                    as.setScores(sub);
                    as.doAlignment(sq1, sq2);
                }
                fin = System.currentTimeMillis();
                match = this.chopSequence(as.getMatch());
                algoName = this.formatAlgoName(as.getClass().getName());
                score = as.getScore();
            } else if (aa != null) {
                start = System.currentTimeMillis();
                for (i = 0; i < numRepeats; ++i) {
                    aa.setGapExtend(gapOpen);
                    aa.setGapOpen(gapOpen);
                    aa.setScores(sub);
                    aa.doAlignment(sq1, sq2);
                }
                fin = System.currentTimeMillis();
                match = this.chopSequence(aa.getMatch());
                algoName = this.formatAlgoName(aa.getClass().getName());
                score = aa.getScore();
            } else if (ar != null) {
                start = System.currentTimeMillis();
                for (i = 0; i < numRepeats; ++i) {
                    ar.setGapOpen(gapOpen);
                    ar.setScores(sub);
                    ((AlignRepeat)ar).setThreshold(threshold);
                    ((AlignRepeat)ar).doAlignment(sq1, sq2);
                }
                fin = System.currentTimeMillis();
                match = this.chopSequence(ar.getMatch());
                algoName = this.formatAlgoName(ar.getClass().getName());
                score = ((AlignRepeat)ar).getScore();
            } else {
                start = System.currentTimeMillis();
                for (i = 0; i < numRepeats; ++i) {
                    ((AlignRepeatAffine)ara).setGapExtend(gapExtend);
                    ara.setGapOpen(gapOpen);
                    ((AlignRepeat)ara).setThreshold(threshold);
                    ara.setScores(sub);
                    ((AlignRepeatAffine)ara).doAlignment(sq1, sq2);
                }
                fin = System.currentTimeMillis();
                match = this.chopSequence(((Align)ara).getMatch());
                algoName = this.formatAlgoName(ara.getClass().getName());
                score = ((AlignRepeatAffine)ara).getScore();
            }
            long timeTaken = fin - start;
            outPut = outPut.concat(numRepeats + " repeat(s) of " + algoName + " took " + timeTaken + "ms.\n\n");
            outPut = ara == null ? outPut.concat("Alignment (Score " + score + "):\n\n") : outPut.concat("Alignment (Total Score " + score + "):\n\n");
            outPut = outPut.concat(match + "\n" + "\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\\n");
            System.out.println(outPut);
        } else {
            float score;
            String algoName;
            String match;
            long fin;
            long start;
            SequenceShuffler shuff = new SequenceShuffler();
            if (as != null) {
                start = System.currentTimeMillis();
                as.setGapOpen(gapOpen);
                as.setScores(sub);
                shuff.shuffle(as, sq1, sq2, numShuffles);
                as.doAlignment(sq1, sq2);
                fin = System.currentTimeMillis();
                match = this.chopSequence(as.getMatch());
                algoName = this.formatAlgoName(as.getClass().getName());
                score = as.getScore();
            } else if (aa != null) {
                start = System.currentTimeMillis();
                aa.setGapExtend(gapOpen);
                aa.setGapOpen(gapOpen);
                aa.setScores(sub);
                shuff.shuffle(aa, sq1, sq2, numShuffles);
                aa.doAlignment(sq1, sq2);
                fin = System.currentTimeMillis();
                match = this.chopSequence(aa.getMatch());
                algoName = this.formatAlgoName(aa.getClass().getName());
                score = aa.getScore();
            } else if (ar != null) {
                start = System.currentTimeMillis();
                ar.setGapOpen(gapOpen);
                ar.setScores(sub);
                ((AlignRepeat)ar).setThreshold(threshold);
                shuff.shuffle(ar, sq1, sq2, numShuffles);
                ((AlignRepeat)ar).doAlignment(sq1, sq2);
                fin = System.currentTimeMillis();
                match = this.chopSequence(ar.getMatch());
                algoName = this.formatAlgoName(ar.getClass().getName());
                score = ((AlignRepeat)ar).getScore();
            } else {
                start = System.currentTimeMillis();
                ((AlignRepeatAffine)ara).setGapExtend(gapExtend);
                ara.setGapOpen(gapOpen);
                ((AlignRepeat)ara).setThreshold(threshold);
                ara.setScores(sub);
                shuff.shuffle(ara, sq1, sq2, numShuffles);
                ((AlignRepeatAffine)ara).doAlignment(sq1, sq2);
                fin = System.currentTimeMillis();
                match = this.chopSequence(((Align)ara).getMatch());
                algoName = this.formatAlgoName(ara.getClass().getName());
                score = ((AlignRepeatAffine)ara).getScore();
            }
            long timeTaken = fin - start;
            outPut = outPut.concat(numShuffles + " shuffle(s) of " + algoName + " took " + timeTaken + "ms.\n\n");
            outPut = ara == null ? outPut.concat("Alignment (Score " + score + "):\n\n") : outPut.concat("Alignment (Total Score " + score + "):\n\n");
            outPut = outPut.concat(match + "\n");
            outPut = outPut.concat("Shuffling " + numShuffles + " times:\tMean: " + shuff.getMean() + "\tstdev: " + shuff.getStdev() + "\n\n\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\\n");
            System.out.println(outPut);
        }
        try {
            PrintWriter pw = new PrintWriter(new FileWriter("alignment_log.txt", true));
            pw.print(outPut + "\n\n");
            pw.close();
            System.out.println("result logged in alignment_log.txt.\n");
        }
        catch (Exception e) {
            System.out.println("error writing logfile\n" + e);
        }
        try {
            this.relaunch = false;
            System.out.println("Do you wish to perform another alignment with these sequences(y/n):");
            String another = this.readInput("? ");
            if (another.toLowerCase().equals("y")) {
                this.relaunch = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private String readInput(String s) {
        System.out.print(s);
        try {
            return in.readLine();
        }
        catch (IOException e) {
            System.out.println("error reading from keyboard!\n" + e);
            return null;
        }
    }

    private String formatAlgoName(String algoName) {
        int cc;
        String currentChar = "";
        for (cc = algoName.length(); !currentChar.equals(".") && cc >= 0; --cc) {
            currentChar = algoName.substring(cc - 1, cc);
        }
        return algoName.substring(cc + 1);
    }

    private String chopSequence(String[] sq) {
        if (sq[0].length() != sq[1].length()) {
            return "error! cannot chop sequences of different lengths with this method";
        }
        String s = "";
        int size = sq[1].length();
        for (int i = 100; i < size + 100; i += 100) {
            if (i > size) {
                s = s.concat(sq[0].substring(i - 100, size) + "\n");
                s = s.concat(sq[1].substring(i - 100, size) + "\n\n");
                continue;
            }
            s = s.concat(sq[0].substring(i - 100, i) + "\n");
            s = s.concat(sq[1].substring(i - 100, i) + "\n\n");
        }
        return s;
    }

    public static void main(String[] args) {
        try {
            new AlignCommand(args[0], args[1]);
        }
        catch (Exception e) {
            System.out.println(e);
            new AlignCommand();
        }
    }
}

