% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordUncerFlagR.R
\name{coordUncerFlagR}
\alias{coordUncerFlagR}
\title{Flag occurrences with an uncertainty threshold}
\usage{
coordUncerFlagR(
  data = NULL,
  uncerColumn = "coordinateUncertaintyInMeters",
  threshold = NULL
)
}
\arguments{
\item{data}{A data frame or tibble. Occurrence records as input.}

\item{uncerColumn}{Character. The column to flag uncertainty in.}

\item{threshold}{Numeric. The uncertainty threshold. Values equal to, or greater than, this
threshold will be flagged.}
}
\value{
The input data with a new column, .uncertaintyThreshold.
}
\description{
To use this function, the user must choose a column, probably "coordinateUncertaintyInMeters"
and a threshold above which occurrences will be flagged for geographic uncertainty.
}
\examples{
# Run the function
beesRaw_out <- coordUncerFlagR(data = beesRaw,
                               uncerColumn = "coordinateUncertaintyInMeters",
                               threshold = 1000)
# View the output
table(beesRaw_out$.uncertaintyThreshold, useNA = "always")
}
