% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidence_CJ.R
\name{evidence_CJ}
\alias{evidence_CJ}
\title{Evidence estimation via Chib and Jeliazkov's method}
\usage{
evidence_CJ(formula, prior.mean, prior.sigma, nits, burnin, thin = 1,
  num.samples = 5000, tunePL = 2, seed = NA, info.adjustPL = NULL)
}
\arguments{
\item{formula}{formula; an \code{\link[ergm]{ergm}} formula object,
of the form  <network> ~ <model terms>
where <network> is a \code{\link[network]{network}} object
and <model terms> are \code{ergm-terms}.}

\item{prior.mean}{vector; Prior means.}

\item{prior.sigma}{matrix; Prior covariance matrix.}

\item{nits}{count; Number of MCMC iterations after burn-in for the adjusted pseudo-posterior estimation.}

\item{burnin}{count; Number of burn-in iterations at the beginning of an MCMC run for the adjusted pseudo-posterior estimation.}

\item{thin}{count; Thinning interval used in the simulation for the adjusted pseudo-posterior estimation. The number of MCMC iterations must be divisible by this value.}

\item{num.samples}{integer; number of samples used in the marginal likelihood estimate. Must be <=(nits-burnin).}

\item{tunePL}{count; Tuning parameter for the Metropolis sampling for the pseudo-posterior estimation.}

\item{seed}{The seed for the random number generator. See \code{\link[MCMCpack]{MCMCmetrop1R}}.}

\item{info.adjustPL}{Transformation parameters for
adjusting the pseudolikelihood function \code{\link[Bergm]{adjustPL}}.}
}
\description{
Function to estimate the evidence (marginal likelihood) with Chib and Jeliazkov's method, 
based on the adjusted pseudolikelihood function.
}
\examples{
\dontrun{
# Load the florentine marriage network:
data(florentine)

flo.formula <- flomarriage ~ edges + kstar(2)

info.adjustPL <- adjustPL(formula = flo.formula,
                          aux.iters    = 100, 
                          noisy.nsim   = 50,   
                          noisy.thin   = 50,   
                          ladder       = 30,   
                          estimate     = "MLE",
                          control      = control.ergm(MCMC.samplesize=2000))

# Specify a prior distribution: 
mean.priors  <- rep(0, 2)
sigma.priors <- diag(5, 2)          
                                                
# MCMC sampling and evidence estimation:
Chib.est.evidence <- evidence_CJ(formula      = flo.formula,
                                 prior.mean   = mean.priors,   
                                 prior.sigma  = sigma.priors,
                                 nits         = 30000,
                                 burnin       = 5000,
                                 thin         = 1,
                                 num.samples  = 25000,
                                 tunePL       = 2,
                                 info.adjustPL = info.adjustPL)                         
                                   
# MCMC diagnostics and posterior summaries:
bergm.output(Chib.est.evidence)
  
# Log-marginal likelihood estimate:             
Chib.est.evidence$log.evidence
}

}
\references{
Caimo, A., & Friel, N. (2013). Bayesian model selection for exponential random graph models. 
Social Networks, 35(1), 11-24. \url{https://arxiv.org/abs/1201.2337}

Bouranis, L., Friel, N., & Maire, F. (2018). Bayesian model selection for exponential 
random graph models via adjusted pseudolikelihoods. 
Journal of Computational and Graphical Statistics, 1-13. 
\url{https://arxiv.org/abs/1706.06344}
}
