% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{prob_pathogenic}
\alias{prob_pathogenic}
\title{Calculate probability of pathogencity for variants in region given a prior probability of association between case label and the region}
\usage{
prob_pathogenic(y, G, ploidy = rep(2L, length(y)), dominant_prior = 0.01,
  recessive_prior = 0.01, gamma0_shape = c(2, 100), by_MOI = FALSE, ...)
}
\arguments{
\item{y}{Logical vector of case (\code{TRUE}) control (\code{FALSE}) status.}

\item{G}{Integer matrix of variant counts per individual, one column per individual and one row per variant.}

\item{ploidy}{Integer vector giving ploidy of samples.}

\item{dominant_prior}{Prior probability of gamma 1 model with dominant mode of inheritance.}

\item{recessive_prior}{Prior probability of gamma 1 model with recessive mode of inheritance.}

\item{gamma0_shape}{Beta shape hyper-priors for prior on rate of case labels.}

\item{by_MOI}{Logical value determining whether to return probabilities broken down by mode of inheritance.}

\item{...}{Other arguments to pass to \code{\link{bevimed}}.}
}
\value{
Probabilities of pathogenicity.
}
\description{
Calculate probability of pathogencity for variants in region given a prior probability of association between case label and the region
}

