% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{region_association_evidence}
\alias{region_association_evidence}
\title{Calculate evidence of under pathogenic locus model}
\usage{
region_association_evidence(y, G, min_ac = 1L, tau_shape = c(1, 1),
  pi_shape = c(2, 1))
}
\arguments{
\item{y}{Logical vector of case (\code{TRUE}) control (\code{FALSE}) status.}

\item{G}{Integer/logical vector of genotypes by individual corresponding to case-control label \code{y} giving the 'rare variant counts'/'presence of rare variant indicators'.}

\item{min_ac}{Numeric vector of length the same as \code{y} or length \code{1} (in which case it is repeated to make it the same length as \code{y}) giving the minimum number of alleles at pathogenic variant sites each individual requires in order to classify as having a `pathogenic allele configuration'. If For example, \code{1} could correspond to hypothesis of dominant inheritance hypothesis. If there are differences in ploidy between individuals in the locus, it is necessary to set it on an sample level basis - e.g. to incorporate information about gender if the locus lies on the X chromosome.}

\item{tau_shape}{Beta shape hyper-priors for prior on rate of affection (i.e. being a case) amongst individuals with non-pathogenic variant combinations (i.e. they have less than \code{min_ac} variants.}

\item{pi_shape}{Beta shape hyper-priors for prior on rate of affection (i.e. being a case) amongst individuals with pathogenic variant combinations (i.e. they have at least \code{min_ac} variants.}
}
\value{
Log marginal likelihood.
}
\description{
Marginal probability of model with aggregated allele counts.
}
\seealso{
\code{\link{gamma0_evidence}}
}

