% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{lower_bound_gamma1_evidence}
\alias{lower_bound_gamma1_evidence}
\title{Calculate log lower bound for marginal probability under model gamma = 1}
\usage{
lower_bound_gamma1_evidence(y, G, min_ac = 1L, by_term = FALSE,
  tau_shape = c(1, 1), pi_shape = c(6, 1), omega_shape = c(2, 8),
  sum_over_variants = seq(length.out = ncol(G)))
}
\arguments{
\item{y}{Logical vector of case (\code{TRUE}) control (\code{FALSE}) status.}

\item{G}{Integer matrix of variant counts per individual, one row per individual and one column per variant.}

\item{min_ac}{Numeric vector of length the same as \code{y} or length \code{1} (in which case it is repeated to make it the same length as \code{y}) giving the minimum number of alleles at pathogenic variant sites each individual requires in order to classify as having a `pathogenic allele configuration'. If For example, \code{1} could correspond to hypothesis of dominant inheritance hypothesis. If there are differences in ploidy between individuals in the locus, it is necessary to set it on an sample level basis - e.g. to incorporate information about gender if the locus lies on the X chromosome.}

\item{by_term}{Calculate probability that individual terms are pathogenic conditional on model gamma=1.}

\item{tau_shape}{Beta shape hyper-priors for prior on rate of affection (i.e. being a case) amongst individuals with non-pathogenic variant combinations (i.e. they have less than \code{min_ac} variants.}

\item{pi_shape}{Beta shape hyper-priors for prior on rate of affection (i.e. being a case) amongst individuals with pathogenic variant combinations (i.e. they have at least \code{min_ac} variants.}

\item{omega_shape}{Beta shape hyper-priors for prior on rate of pathogenicity amongst variants.}

\item{sum_over_variants}{Subset of variants for whose power set to calculate the direct sum over.}
}
\value{
Log of marginal likelihood.
}
\description{
Calculate log lower bound for marginal probability of data under model gamma = 1 by summing likelihood over pathogenic variant partitions.
}
\seealso{
\code{\link{exact_evidence}}
}

