% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{bevimed_polytomous}
\alias{bevimed_polytomous}
\title{Model selection for multiple association models}
\usage{
bevimed_polytomous(
  y,
  G,
  ploidy = rep(2L, length(y)),
  variant_sets,
  prior_prob_association = rep(0.01/length(variant_sets), length(variant_sets)),
  tau0_shape = c(1, 1),
  moi = rep("dominant", length(variant_sets)),
  model_specific_args = vector(mode = "list", length = length(variant_sets)),
  ...
)
}
\arguments{
\item{y}{Logical vector of case (\code{TRUE}) control (\code{FALSE}) status.}

\item{G}{Integer matrix of variant counts per individual, one row per individual and one column per variant.}

\item{ploidy}{Integer vector giving ploidy of samples.}

\item{variant_sets}{List of integer vectors corresponding to sets of indices of \code{G}, each of which is to be considered in a model explaining the phenotype, \code{y}.}

\item{prior_prob_association}{The prior probability of association.}

\item{tau0_shape}{Beta shape hyper-priors for prior on rate of case labels.}

\item{moi}{Character vector giving mode of inheritance for each model.}

\item{model_specific_args}{List of named lists of parameters to use in \code{\link{bevimed_m}} applications for specific models.}

\item{...}{Other arguments to pass to \code{\link{bevimed_m}}.}
}
\description{
Apply bevimed to the no association model (gamma = 0) and multiple association models for different sets of variants, for instance, corresponding to different functional consequences.
}
\references{
Greene et al., A Fast Association Test for Identifying Pathogenic Variants Involved in Rare Diseases, The American Journal of Human Genetics (2017), http://dx.doi.org/10.1016/j.ajhg.2017.05.015.
}
\seealso{
\code{\link{bevimed_m}}, \code{\link{bevimed}}
}
