% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{DAGscore}
\alias{DAGscore}
\title{Calculating the BGe/BDe score of a single DAG}
\usage{
DAGscore(n, scoreparam, incidence)
}
\arguments{
\item{n}{number of nodes in the Bayesian network}

\item{scoreparam}{an object of class \code{scoreparameters}, containing the data and scoring parameters; see constructor function \code{\link{scoreparameters}}}

\item{incidence}{a square matrix of dimensions equal to the number of nodes, representing the adjacency matrix of a DAG;  the matrix entries are in \code{\{0,1\}} such that \code{incidence[i,j]} equals 1 if there is a directed edge from node \code{i} to node \code{j} in the DAG and 
\code{incidence[i,j]} equals 0 otherwise}
}
\value{
the log of the BGe or BDe score of the DAG
}
\description{
This function calculates the score of a DAG defined by its adjacency matrix. Acceptable data matrices are homogeneous with all variables of the same type, either continuous or binary.  The BGe score is evaluated in the case of continuous data and the BDe score is evaluated for binary variables.
}
\examples{
myDAG<-pcalg::randomDAG(20, prob=0.15, lB = 0.4, uB = 2) 
myData<-pcalg::rmvDAG(200, myDAG) 
adjacency<-dag2adjacencymatrix(myDAG)
myScore<-scoreparameters(20,"bge",myData)
DAGscore(20, myScore, adjacency)
}
\references{
Geiger D and Heckerman D (2002). Parameter priors for directed acyclic graphical models and the characterization of several probability distributions. The Annals of Statistics 30, 1412-1440.

Heckerman D and Geiger D (1995). Learning Bayesian networks: A unification for discrete and Gaussian domains. In Eleventh Conference on Uncertainty in Artificial Intelligence, pages 274-284.

Kuipers J, Moffa G and Heckerman D (2014). Addendum on the scoring of Gaussian directed acyclic graphical models. The Annals of Statistics 42, 1689-1691.
}
