% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IPS.R
\name{IPS}
\alias{IPS}
\title{IPS}
\usage{
IPS(TarnetPairs, IIS)
}
\arguments{
\item{TarnetPairs}{The result returned by TarNet() function.}

\item{IIS}{The result returned by IIS() function.}
}
\value{
IPS_res A data frame including the importance pair score (IPS) of the target network.
}
\description{
A function is used to compute the importance pair score (IPS) of the network returned by the TarNet() function.
}
\examples{
IIScore <- IIS(microApath = micro.eg, metaApath = metabo.eg,
               conf = confounder.eg, groupInfo = groupInfo.eg)
MMfunc_res <- MMfunc(IIS = IIScore)
TarNet_res <- TarNet(IIS = IIScore, mm2path = MMfunc_res)
IPScore <- IPS(TarnetPairs = TarNet_res,IIS = IIScore)
}
