% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_bar_categ.R
\name{auto_bar_categ}
\alias{auto_bar_categ}
\title{Automatic generation of barplot with percentages}
\usage{
auto_bar_categ(
  data,
  groupvar = NULL,
  bar_args = list(),
  theme_func = theme_serene,
  lang_labs = c("EN", "SPA"),
  showpercent = TRUE
)
}
\arguments{
\item{data}{Name of the dataframe}

\item{groupvar}{Name of the grouping variable. Grouping variable will be used in "fill" for aesthetics argument in the creation of each ggplot object. If not provided, the function take each variable as grouping and does not display the "fill" legend.}

\item{bar_args}{List of arguments to be passed to "geom_bar". If \code{NULL}, the function uses default arguments such as:
\itemize{
\item position = "dodge"
\item colour = "black"
\item linewidth = 0.9
\item alpha = 0.5
}}

\item{theme_func}{Theme of the generated plots. Must be the name of the function without parenthesis. Use for example: \code{theme_minimal} instead of \code{theme_minimal()}}

\item{lang_labs}{Language of displayed labels. If null, default is spanish.}

\item{showpercent}{Logical atribute to indicate if the graph should include percentages}
}
\value{
Returns a list containing all barplots as ggplot object. Can be accessed via $ operator
}
\description{
Automatically generates barplot stratified by group variables with or without percentages.
}
\examples{
data<-data.frame(categ = rep(letters[1:2], 10),
var1 = rep(LETTERS[4:5], 10),
var2 = rep(LETTERS[6:7], 10),
var3 = rep(LETTERS[8:9], 10),
var4 = rep(LETTERS[10:11], 10))

data$categ <- as.factor(data$categ)
data$var1 <- as.factor(data$var1)
data$var2 <- as.factor(data$var2)
data$var3 <- as.factor(data$var3)
data$var4 <- as.factor(data$var4)

barplot_list<-auto_bar_categ(data = data, groupvar = "categ", lang_labs = "EN")

barplot_list$var1


# Example using `groupvar` argument as `NULL`
auto_bar_categ(data = data)$var2


}
