% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Other_Indices.R
\name{ARPB}
\alias{ARPB}
\title{ARPB}
\usage{
ARPB(Lambda, UniLambda)
}
\arguments{
\item{Lambda}{is a matrix of factor loadings}

\item{UniLambda}{is a matrix of factor loadings}
}
\value{
a list where the first element is the average absolute relative paramter bias, and the second
element is a vector of absolute relative bias by item
}
\description{
\code{ARPB} computes absolute relative bias in factor loadings between the general factor of a
bifactor model and a unidimensional model.
}
\details{
\code{ARPB} is called by \code{\link{bifactorIndices}} and the various convenience functions
for exploratory models and/or Mplus output,
which are the only functions in this package intended for casual users.
}
\examples{
Lambda <- matrix(c(.82, .10,   0,   0,
                   .77, .35,   0,   0,
                   .79, .32,   0,   0,
                   .66, .39,   0,   0,
                   .51,   0, .71,   0,
                   .56,   0, .43,   0,
                   .68,   0, .13,   0,
                   .60,   0, .50,   0,
                   .83,   0,   0, .47,
                   .60,   0,   0, .27,
                   .78,   0,   0, .28,
                   .55,   0,   0, .75),
                   ncol = 4, byrow = TRUE)
colnames(Lambda) <- c("General", "SF1", "SF2", "SF3")
UniLambda <- c(.78, .84, .82, .77, .69, .62, .69, .66, .82, .56, .74, .65)
ARPB(Lambda, UniLambda)


}
\seealso{
\code{\link{bifactorIndices}}
}
