% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdSVD}
\alias{bdSVD}
\title{k first SVD components for DelayedArray}
\usage{
bdSVD(X, k = 0L, nev = 0L, bcenter = TRUE, bscale = TRUE)
}
\arguments{
\item{X}{numerical or Delayed Array matrix}

\item{k}{number of eigen values , this should satisfy k = min(n, m) - 1}

\item{nev}{(optional, default nev = n-1) Number of eigenvalues requested. This should satisfy 1<= nev <= n, where n is the size of matrix.}

\item{bcenter}{(optional, defalut = TRUE) . If center is TRUE then centering is done by subtracting the column means (omitting NAs) of x from their corresponding columns, and if center is FALSE, no centering is done.}

\item{bscale}{(optional, defalut = TRUE) .  If scale is TRUE then scaling is done by dividing the (centered) columns of x by their standard deviations if center is TRUE, and the root mean square otherwise. If scale is FALSE, no scaling is done.}
}
\value{
u eigenvectors of AA^t, mxn and column orthogonal matrix

v eigenvectors of A^tA, nxn orthogonal matrix

d singular values, nxn diagonal matrix (non-negative real values)
}
\description{
This function gets k first components from svd decomposition of numerical or Delayed Array
}
\examples{

library(DelayedArray)

n <- 500
A <- matrix(rnorm(n*n), nrow=n, ncol=n)
AD <- DelayedArray(A)

# svd without normalization
decsvd <- bdSVD( A, bscale = FALSE, bcenter = FALSE ) # No matrix normalization
decsvd$d
decsvd$u

# svd with normalization
decvsd <- bdSVD( A, bscale = TRUE, bcenter = TRUE) # Matrix normalization

decsvd$d
decsvd$u

# svd with scaled matrix (sd)
decvsd <- bdSVD( A, bscale = TRUE, bcenter = FALSE) # Scaled matrix

decsvd$d
decsvd$u
# svd with centered matrix (sd)
decvsd <- bdSVD( A, bscale = FALSE, bcenter = TRUE) # Centered matrix
decsvd$d
decsvd$u

}
