% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install.github}
\alias{install.github}
\title{Install from Github}
\usage{
install.github(name = "", download.dir = NULL, destdir = NULL,
  version = NULL, show.all.versions = FALSE, name.saved = NULL,
  github.cfg = system.file("extdata", "github.toml", package =
  "BioInstaller"), db = Sys.getenv("BIO_SOFTWARES_DB_ACTIVE",
  system.file("extdata", "softwares_db_demo.yaml", package = "BioInstaller")),
  download.only = FALSE, showWarnings = FALSE, dependence.need = TRUE,
  extra.list = list(), rcmd.parse = TRUE, bash.parse = TRUE,
  glue.parse = TRUE, glue.flag = "!!glue", save.to.db = TRUE,
  verbose = TRUE, ...)
}
\arguments{
\item{name}{Software name}

\item{download.dir}{A string, point the source code download destdir}

\item{destdir}{A string, point the install path}

\item{version}{Software version}

\item{show.all.versions}{Logical wheather show all avaliable version can be install}

\item{name.saved}{Software name when you want to install different version, you
can use this to point the installed softwares name like 'GATK-3.7'}

\item{github.cfg}{Configuration file of installed by github url,
default is system.file('extdata', 'github.toml', package='BioInstaller')}

\item{db}{File of saving softwares infomation, default is Sys.getenv('BIO_SOFTWARES_DB_ACTIVE',
system.file('extdata', 'softwares_db_demo.yaml', package = 'BioInstaller'))}

\item{download.only}{Logicol indicating wheather only download source or file (non-github)}

\item{showWarnings}{Logical should the warnings on failure be shown?}

\item{dependence.need}{Logical should the dependence should be installed}

\item{extra.list}{A list that can replace the configuration file '{{debug}}' by list(debug = TRUE), and {{debug}} will be setted to TRUE}

\item{rcmd.parse}{Logical wheather parse '@>@str_replace('abc', 'b', 'c')@<@' in config to 'acc'}

\item{bash.parse}{Logical wheather parse '#>#echo $HOME#<#' in config to your HOME PATH}

\item{glue.parse}{Logical wheather parse '!!glue{1:5}' in config to ['1','2','3','4','5']; 
['nochange', '!!glue(1:5)', 'nochange'] => ['nochange', '1', '2', '3', '4', '5', 'nochange']}

\item{glue.flag}{A character flage indicating wheater run glue() function to parse (Default is !!glue)}

\item{save.to.db}{Ligical indicating wheather save the install infomation in db}

\item{verbose}{Ligical indicating wheather show the log message}

\item{...}{Other key and value paired need be saved in BioInstaller passed to \code{\link{change.info}}}
}
\value{
Bool Value
}
\description{
Install from Github
}
\examples{
db <- sprintf('\%s/.BioInstaller', tempdir())
set.biosoftwares.db(db)
install.github('bwa', show.all.versions = TRUE)
unlink(db)
}
