% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/474-extractDrugHybridization.R
\name{extrDrugHybridization}
\alias{extrDrugHybridization}
\title{Calculate the Hybridization Molecular Fingerprints (in Compact Format)}
\usage{
extrDrugHybridization(molecules, depth = 6, size = 1024,
  silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{depth}{The search depth. Default is \code{6}.}

\item{size}{The length of the fingerprint bit string. Default is \code{1024}.}

\item{silent}{Logical. Whether the calculating process 
should be shown or not, default is \code{TRUE}.}
}
\value{
A list, each component represents one of the molecules, each element 
in the component represents the index of which element in the fingerprint is 1.
Each component's name is the length of the fingerprints.
}
\description{
Calculate the Hybridization Molecular Fingerprints (in Compact Format)
}
\details{
Calculate the hybridization molecular fingerprints. 
Similar to the standard type, but only consider hybridization state.
This is hashed fingerprints, with a default length of 1024.
}
\examples{
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
fp  = extrDrugHybridization(mol)
head(fp)

}
\seealso{
\link{extrDrugHybridizationComplete}
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{extrDrugHybridization}
