% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1101-randomForest.R
\name{rf.cv}
\alias{rf.cv}
\title{The Cross-Validation of Classification and Regression models using Random Forest}
\usage{
rf.cv(xtr, ytr, cv.fold = 5, type = "regression", trees = 500,
  mtrysize = 10)
}
\arguments{
\item{xtr}{A data frame or a matrix of predictors.}

\item{ytr}{A response vector. If a factor, classification is assumed, otherwise 
regression is assumed.}

\item{cv.fold}{The fold, the defalut is 5.}

\item{type}{method type.}

\item{trees}{Number of trees to grow.  This should not be set to too small a 
number, to ensure that every input row gets predicted at least 
a few times.}

\item{mtrysize}{Number of variables randomly sampled as candidates at each 
split.  Note that the default values are different for 
classification (sqrt(p) where p is number of variables in 
\code{xtr}) and regression (p/3)}
}
\value{
if type is regression, the retrun a list containing four components:
\itemize{
\item \code{RFpred} - the predicted values of the input data based on cross-validation
\item \code{Error} - error for all samples
\item \code{RMSECV} - Root Mean Square Error for cross-validation
\item \code{Q2} - R2 for cross-validation
}
if type is classification, the retrun a list containing four components:
\itemize{
\item \code{table} - confusion matrix
\item \code{ACC} - accuracy
\item \code{SE} - sensitivity
\item \code{SP} - specifivity
\item \code{F1} - a measure of a test's accuracy.
\item \code{MCC} - Mathews correlation coefficient
\item \code{RFPred} - the predicted values
\item \code{prob} - the predicted probability values
}
}
\description{
The Cross-Validation of Classification and Regression models using Random Forest
}
\details{
\code{rf.cv} implements Breiman's random forest algorithm for classification and 
regression. here we use it to make a k-fold cross-validation
}
\examples{
training = read.csv(system.file('sysdata/training2.csv', package = 'BioMedR'), header = TRUE)
y = training[, 1]
x = training[, -1]
rf.tr <- rf.cv(x, y)
}
\references{
Breiman, L. (2001), \emph{Random Forests}, Machine Learning 45(1), 5-32.
}
\seealso{
See \code{\link{pls.cv}} for the Cross-Validation of Classification and 
Regression models using PLS
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>
}
\keyword{rf.cv}
