% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/502-extractProtDC.R
\name{extrProtDC}
\alias{extrProtDC}
\title{Dipeptide Composition Descriptor}
\usage{
extrProtDC(x)
}
\arguments{
\item{x}{A character vector, as the input protein sequence.}
}
\value{
A length 400 named vector
}
\description{
Dipeptide Composition Descriptor
}
\details{
This function calculates the Dipeptide Composition descriptor (Dim: 400).
}
\examples{
x = readFASTA(system.file('protseq/P00750.fasta', package = 'BioMedR'))[[1]]
extrProtDC(x)

}
\references{
M. Bhasin, G. P. S. Raghava.
Classification of Nuclear Receptors Based on 
Amino Acid Composition and Dipeptide Composition. 
\emph{Journal of Biological Chemistry}, 2004, 279, 23262.
}
\seealso{
See \code{\link{extrProtTC}} for tripeptide composition descriptors.
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{Composition}
\keyword{DC}
\keyword{Dipeptide}
\keyword{extrProtDC}
\keyword{extract}
