% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/477-extractDrugPubChem.R
\name{extrDrugPubChem}
\alias{extrDrugPubChem}
\title{Calculate the PubChem Molecular Fingerprints (in Compact Format)}
\usage{
extrDrugPubChem(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process 
should be shown or not, default is \code{TRUE}.}
}
\value{
A list, each component represents one of the molecules, each element 
in the component represents the index of which element in the fingerprint is 1.
Each component's name is the length of the fingerprints.
}
\description{
Calculate the PubChem Molecular Fingerprints (in Compact Format)
}
\details{
Calculate the 881 bit fingerprints defined by PubChem.
}
\examples{
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
fp  = extrDrugPubChem(mol)
head(fp)

}
\seealso{
\link{extrDrugPubChemComplete}
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{extrDrugPubChem}
