% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plantcare_plot.R
\name{plantcare_plot}
\alias{plantcare_plot}
\title{plantcare_plot}
\usage{
plantcare_plot(
  plantcare_file,
  promoter_length = 2000,
  the_order = NULL,
  shape = "Rect",
  r = 6,
  legend_size = 15,
  element_color = NULL
)
}
\arguments{
\item{plantcare_file}{The path of plantcare result file (.tab).}

\item{promoter_length}{The promoter length.}

\item{the_order}{The path of order file. A List of Gene ID , One ID Per Line.}

\item{shape}{RoundRect or Rect.}

\item{r}{The radius of rounded corners.}

\item{legend_size}{The size of legend.}

\item{element_color}{The color set of cis-element.}
}
\value{
p
}
\description{
Visualization of cis-element in plantcare result file
}
\examples{
plantcare_path <- system.file("extdata", "plantCARE_output.tab", package = "BioVizSeq") 
plantcare_plot(plantcare_path, promoter_length = 2000)
}
\author{
Shiqi Zhao
}
