% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/available.R
\name{available}
\alias{available}
\title{Discover packages available for installation.}
\usage{
available(pattern = "", include_installed = TRUE)
}
\arguments{
\item{pattern}{character(1) pattern to filter (via
\code{grep(pattern=...)}) available packages; the filter is not case
sensitive.}

\item{include_installed}{logical(1) When \code{TRUE}, include installed
packages in list of available packages; when \code{FALSE}, exclude
installed packages.}
}
\value{
\code{character()} vector of package names available for
installation.
}
\description{
The function lists all packages available from \code{repositories()} when
no pattern is provided. This usually includes CRAN and Bioconductor
packages. The function can also be used to check for package name
availability. Common use cases include annotation package lookups by
organism short name (e.g., "hsapiens").
}
\examples{
if (interactive()) {
  avail <- BiocManager::available()
  length(avail)

  BiocManager::available("bs.*hsapiens")
}
}
