% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDS.R
\name{SDS}
\alias{SDS}
\title{Generates a list of dispersal vectors.}
\usage{
SDS(probDist, DIST, npop = 10000)
}
\arguments{
\item{probDist}{Probability Distribution of npop.}

\item{DIST}{vector of possible distances [m] to be sampled for dispersal.}

\item{npop}{number of distance-angle couples that need to be produced.}
}
\value{
data frame of y and x shifts.
}
\description{
This function generates a set of spatial vectors whose length is sampled form a user-defined dispersal kernel and whose direction is sampled randomly from 1 degree to 360 degrees.
}
\examples{
dist<- seq(.1, 30, .1)
prob<- fx(x=dist, a=7, c=2)
deltas<- SDS(DIST=dist, probDist=prob)
}
\author{
Luca Butikofer
}
