% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_LB.R
\name{pred_LB}
\alias{pred_LB}
\title{Predict logistic biplot and thresholds by variable}
\usage{
pred_LB(object, x, ncuts = 100)
}
\arguments{
\item{object}{BiplotML object}

\item{x}{Binary matrix.}

\item{ncuts}{Number of equidistant cuts between 0 and 1 that will be evaluated. By default \code{ncuts = 100}}
}
\value{
This function returns the thresholds per variable, the predicted matrix, the confusion matrix and the BACC.
}
\description{
Predicts the binary matrix and calculates the optimal thresholds per variable that minimize the Balanced Accuracy (BACC)
}
\details{
The threshold for each variable is lowered to minimize the Balanced Accuracy (BACC).
\deqn{BACC = \frac{1}{2} (\frac{TP}{TP+FN} + \frac{TN}{TN+FP}),}
where \code{TP} is the number of true positives, \code{TN} is the number of true negatives, \code{FP} is the number of false positives and \code{FN} is the number of false negatives
}
\examples{
\donttest{
data("Methylation")
LB <- LogBip(Methylation, plot = FALSE)
out <- pred_LB(LB, Methylation)
}
}
