% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivrecSurv.R
\name{bivrecSurv}
\alias{bivrecSurv}
\title{Create a Bivariate Alternating Recurrent Event Object}
\usage{
bivrecSurv(id, episode, xij, yij, d1, d2)
}
\arguments{
\item{id}{Numeric or character vector of subject's unique identifier (i).}

\item{episode}{Vector indicating the observation or episode (j) for a subject (i). This will determine order of events for each subject.}

\item{xij}{Vector with the lengths of time spent in event of Type I for individual i in episode j.}

\item{yij}{Vector with the lengths of time spent in event of Type II for individual i in episode j.}

\item{d1}{Vector of censoring indicator corresponding to Type I gap times (xij): = 1 for uncensored, and = 0 for censored gap times.}

\item{d2}{Vector of censoring indicator corresponding to Type II gap times (yij): = 1 for uncensored, and = 0 for censored gap times. Note that in the last episode (or pair) of gap times, yij is always censored, i.e., d2 = 0.}
}
\value{
A bivrecSurv object ready to be used as the response for analysis using \verb{bivrecReg} or \verb{bivrecNP}.
}
\description{
This function creates a bivariate recurrent survival object to be used as a response variable in a model formula.
}
\details{
All the following data requirements must be met to avoid errors or warnings:
\enumerate{
 \item All variables should have the same length.
 \item The Type I (xij) and Type II (yij) gap times must be numeric and meet the requirements xij\eqn{>}0, yij\eqn{\ge}0 respectively for all observations.
 \item Only unique, positive, consecutive integers starting from 1, are allowed within each subject for episode (i.e., 1, 2, ...), but they should be allowed to be in any order in the raw data as long as they are unique and have no gap within each subject.
 \item Censoring indicators d1 and d2 must be numeric. Only the last episode is allowed to have zero value for either, and for the last episode, the only combinations allowed are (d1, d2) = (0, 0) or (1, 0).
 \item No missing values. If a subject has missing values in any variables, the whole subject's data will not be used.
}
}
\examples{
library(BivRec)
set.seed(28)
sim_data <- simBivRec(nsize=100, beta1=c(0.5,0.5), beta2=c(0,-0.5))
bivrecsurv_data <- with(sim_data, bivrecSurv(id, epi, xij, yij, d1, d2))
class(bivrecsurv_data)
}
