% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gauss_random_field_sim.R
\name{gauss_random_field_sim}
\alias{gauss_random_field_sim}
\title{Gaussian random field neutral model}
\usage{
gauss_random_field_sim(x, corr_range)
}
\arguments{
\item{x}{A SpatRaster object.}

\item{corr_range}{The range of spatial autocorrelation to simulate. Can be estimated using the lisa_clusters function.}
}
\value{
A SpatRaster object with boundary elements.
}
\description{
Simulates a gaussian random field as a neutral landscape of the same extent and resolution as the
input raster, using the same spatial autocorrelation range as the input
}
\examples{
\donttest{
#' data(grassland)
grassland <- terra::rast(grassland_matrix, crs = grassland_crs)
terra::ext(grassland) <- grassland_ext

corr <- lisa_clusters(grassland)
simulation <- gauss_random_field_sim(grassland, corr)
terra::plot(simulation)
}

}
\references{
James, P. M. A., Fleming, R.A., & Fortin, M.-J. (2010) Identifying significant scale-specific spatial boundaries using wavelets and null models: Spruce budworm defoliation in Ontario, Canada as a case study. Landscape Ecology, 6, 873-887.
}
\author{
Amy Luo
}
