% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BranchGLMCIs.R
\name{plotCI}
\alias{plotCI}
\title{Plot Confidence Intervals}
\usage{
plotCI(
  CIs,
  points = NULL,
  ylab = "",
  ylas = 2,
  cex.y = 1,
  decreasing = FALSE,
  ...
)
}
\arguments{
\item{CIs}{a numeric matrix of confidence intervals, must have exactly 2 columns.
The variable names displayed in the plot are taken from the column names.}

\item{points}{points to be plotted in the middle of the CIs, typically means or medians.
The default is to plot the midpoints of the intervals.}

\item{ylab}{a label for the y-axis.}

\item{ylas}{the style of the y-axis label, see more about this at \code{las} in \link{par}.}

\item{cex.y}{font size used for variable names on y-axis.}

\item{decreasing}{a logical value indicating if confidence intervals should be
displayed in decreasing or increasing order according to points. Can use NA
if no ordering is desired.}

\item{...}{further arguments passed to \link{plot.default}.}
}
\value{
This only produces a plot, nothing is returned.
}
\description{
Creates a plot to display confidence intervals.
}
\examples{
Data <- iris
### Fitting linear regression model
mymodel <- BranchGLM(Sepal.Length ~ ., data = Data, family = "gaussian", link = "identity")

### Getting confidence intervals
CIs <- confint.default(mymodel, level = 0.95)
xlim <- c(min(CIs), max(CIs))

### Plotting CIs
par(mar = c(5, 7, 3, 1) + 0.1)
plotCI(CIs, main = "95\% Confidence Intervals", xlim = xlim, cex.y = 0.9, 
xlab = "Beta Coefficients")
abline(v = 0)

}
