% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radiation_parameters.R
\name{sr_ang_calculation}
\alias{sr_ang_calculation}
\title{Solar radiation based in Angstrom formula (sr_ang)
\if{html}{\figure{logo_BrazilMet.png}{options: height= 300 width=auto style = float:right alt= Our logo}}}
\usage{
sr_ang_calculation(latitude, date, n, as, bs)
}
\arguments{
\item{latitude}{A dataframe with latitude in decimal degrees that you want to calculate the ra.}

\item{date}{A dataframe with the dates that you want to calculate the ra.}

\item{n}{The actual duration of sunshine. This variable is recorded with Campbell-Stokes sunshine recorder.}

\item{as}{A dataframe with latitude in decimal degrees that you want to calculate the ra. The values of as = 0.25 is recommended by Allen et al. (1998).}

\item{bs}{A dataframe with the dates that you want to calculate the ra. The values of bs = 0.50 is recommended by Allen et al. (1998).}
}
\value{
A data.frame object with solar radiation data
}
\description{
If global radiation is not measure at station, it can be estimated with this function.
}
\examples{
\dontrun{
sr_ang <- sr_ang_calculation(latitude, date, n, as, bs)
}
}
\author{
Roberto Filgueiras, Luan P. Venancio, Catariny C. Aleman and Fernando F. da Cunha
}
