% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuyseTest-initialization.R
\name{internal-initialization}
\alias{internal-initialization}
\alias{initializeArgs}
\alias{initializeData}
\alias{initializeFormula}
\alias{initializeSurvival_Peto}
\alias{initializeSurvival_Peron}
\title{internal functions for BuyseTest - initialization}
\usage{
initializeArgs(alternative, name.call, censoring, cpus, data, endpoint, formula,
  keep.comparison, method.tte, method.inference, n.resampling, neutral.as.uninf,
  operator, option, prob.alloc, seed, strata, threshold, trace, treatment, type)

initializeData(data, type, endpoint, operator, strata, treatment)

initializeFormula(x)

initializeSurvival_Peto(M.Treatment, M.Control, M.delta.Treatment,
  M.delta.Control, D.TTE, endpoint, type, threshold, index.strataT,
  index.strataC, n.strata)

initializeSurvival_Peron(M.Treatment, M.Control, M.delta.Treatment,
  M.delta.Control, D.TTE, endpoint, type, threshold, index.strataT,
  index.strataC, n.strata)
}
\description{
Functions called by \code{\link{BuyseTest}} to initialize the arguments.
}
\details{
\code{initializeArgs}: Normalize the argument 
\itemize{
\item method.tte, neutral.as.uninf, keep.comparison, n.resampling, seed, cpus, trace: set to default value when not specified.
\item formula: call \code{initializeFormula} to extract arguments.
\item type: convert to numeric.
\item censoring: only keep censoring relative to TTE endpoint. Set to \code{NULL} if no TTE endpoint.
\item threshold: set default threshold to 1e-12 expect for binary variable where it is set to 1/2.
the rational being we consider a pair favorable if X>Y ie X>=Y+1e-12.
When using a threshold e.g. 5 we want X>=Y+5 and not X>Y+5, especially when the measurement is discrete. \cr
\item data: convert to data.table object.
\item method.tte: convert to numeric.
}
and create \code{Wscheme}. \cr \cr

\code{initializeFormula}:  extract \code{treatment}, \code{type}, \code{endpoint}, \code{threshold}, \code{censoring}, \code{operator}, and \code{strata}
from the formula. \cr \cr

\code{initializeData}: Divide the dataset into two, one relative to the treatment group and the other relative to the control group.
Merge the strata into one with the interaction variable.
Extract for each strata the index of the observations within each group.
Apply Efron correction (when method.tte is set to Efron), i.e. set the last event to an observed event.

\code{initializeSurvival}: Compute the survival via KM.
}
\keyword{BuyseTest}
\keyword{function}
\keyword{internal}
