# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title C++ function performing the pairwise comparison over several endpoints. 
#' @description \code{GPC_cpp} call for each endpoint and each strata the pairwise comparison function suited to the type of endpoint and store the results. 
#' @name GPC_cpp
#' 
#' @param endpoint A matrix containing the values of each endpoint (in columns) for each observation (in rows). 
#' @param censoring A matrix containing the values of the censoring variables relative to each endpoint (in columns) for each observation (in rows).
#' @param indexC A list containing the indexes of control observations belonging for each strata. 
#' @param indexT A list containing the indexes of treatment observations belonging for each strata. 
#' @param threshold Store the thresholds associated to each endpoint. Must have length D. The threshold is ignored for binary endpoints. Must have D columns.
#' @param method The index of the method used to score the pairs. Must have length D. 1 for continuous, 2 for Gehan, and 3 for Peron.
#' @param D The number of endpoints.
#' @param n_strata The number of strata. 
#' @param n_TTE The number of time-to-event endpoints. 
#' @param n_UTTE The number of unique time-to-event endpoints.
#' @param Wscheme The matrix describing the weighting strategy. For each endpoint (except the first) in column, weights of each pair are initialized at 1 and multiplied by the weight of the endpoints in rows where there is a 1. Must have D lines and D columns.
#' @param index_endpoint The position of the endpoint at each priority in the argument endpoint. Must have length D. 
#' @param index_censoring The position of the censoring at each priority in the argument censoring. Must have length D. 
#' @param index_UTTE The position, among all the unique tte endpoints, of the TTE endpoints. Equals -1 for non tte endpoints. Must have length n_TTE. 
#' @param reanalyzed Will this endpoint be re-analyzed latter with a different threshold.
#' @param list_survTimeC A list of matrix containing the survival estimates (-threshold, 0, +threshold ...) for each event of the control group (in rows).
#' @param list_survTimeT A list of matrix containing the survival estimates (-threshold, 0, +threshold ...) for each event of the treatment group (in rows).
#' @param list_survJumpC A list of matrix containing the survival estimates and survival jumps when the survival for the control arm jumps.
#' @param list_survJumpT A list of matrix containing the survival estimates and survival jumps when the survival for the treatment arm jumps.
#' @param list_lastSurv A list of matrix containing the last survival estimate in each strata (rows) and treatment group (columns).
#' @param correctionUninf Should the uninformative weight be re-distributed to favorable and unfavorable?
#' @param neutralAsUninf Should paired classified as neutral be re-analyzed using endpoints of lower priority? 
#' @param keepScore Should the result of each pairwise comparison be kept?
#' @param reserve Should vector storing neutral pairs and uninformative pairs be initialized at their maximum possible length?
#' @param returnOnlyDelta Should only the net benefit and win ratio be output?.
#' @keywords function Cpp BuyseTest
NULL

#' @name GPC_cpp
#' @export
GPC_cpp <- function(endpoint, censoring, indexC, indexT, threshold, method, D, n_strata, n_TTE, n_UTTE, Wscheme, index_endpoint, index_censoring, index_UTTE, reanalyzed, list_survTimeC, list_survTimeT, list_survJumpC, list_survJumpT, list_lastSurv, correctionUninf, neutralAsUninf, keepScore, reserve, returnOnlyDelta) {
    .Call(`_BuyseTest_GPC_cpp`, endpoint, censoring, indexC, indexT, threshold, method, D, n_strata, n_TTE, n_UTTE, Wscheme, index_endpoint, index_censoring, index_UTTE, reanalyzed, list_survTimeC, list_survTimeT, list_survJumpC, list_survJumpT, list_lastSurv, correctionUninf, neutralAsUninf, keepScore, reserve, returnOnlyDelta)
}

#' @title C++ Function Computing the Integral Terms for the Peron Method. 
#' @description Compute the integral with respect to the jump in survival for pairs where both outcomes are censored.
#' @name calcIntegralScore_cpp
#' 
#' @param survival [matrix] Contains the jump times in the first column,
#' the survival in the other arm at times plus threshold in the second column,
#' and the jump in survival in the third column.
#' @param start [numeric] Time at which to start the integral.
#' @param lastSurv [numeric,>0] last survival value for the survival function in the second column.
#' @param lastdSurv [numeric,>0] last survival value for the survival function in the third column.
#'
#' @keywords function Cpp internal
#' @export
calcIntegralScore_cpp <- function(survival, start, lastSurv, lastdSurv) {
    .Call(`_BuyseTest_calcIntegralScore_cpp`, survival, start, lastSurv, lastdSurv)
}

