% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc.R
\name{auc}
\alias{auc}
\title{Estimation of the Area Under the ROC Curve}
\usage{
auc(labels, predictions, fold = NULL, observation = NULL,
  direction = ">", null = 0.5, conf.level = 0.95,
  transformation = FALSE)
}
\arguments{
\item{labels}{[integer/character vector] the disease status (should only take two different values).}

\item{predictions}{[numeric vector] A vector with the same length as \code{labels} containing the biomarker values.}

\item{fold}{[character/integer vector] If using cross validation, the index of the fold. 
Should have the same length as \code{labels}.}

\item{observation}{[integer vector] If using cross validation, the index of the corresponding observation in the original dataset.
Necessary to compute the standard error when using cross validation.}

\item{direction}{[character] \code{">"} lead to estimate P[Y>X],
\code{"<"} to estimate P[Y<X],
and \code{"auto"} to estimate max(P[Y>X],P[Y<X]).}

\item{null}{[numeric, 0-1] the value against which the AUC should be compared when computing the p-value.}

\item{conf.level}{[numeric, 0-1] the confidence level of the confidence intervals.}

\item{transformation}{[logical] should a log-log transformation be used when computing the confidence intervals and the p-value.}
}
\value{
A \emph{data.frame} containing for each fold the AUC value with its standard error (when computed).
The last line of the data.frame contains the global AUC value with its standard error.
}
\description{
Estimation of the Area Under the ROC curve, possibly after cross validation,
to assess the discriminant ability of a biomarker regarding a disease status.
}
\details{
Compared to other functions computing the AUC (e.g. the auc fonction of the ROCR package),
the AUC is defined here as P[Y>X] with a strict inequality sign (i.e. not P[Y>=X]).
}
\examples{
library(data.table)

n <- 200
set.seed(10)
X <- rnorm(n)
dt <- data.table(Y = as.factor(rbinom(n, size = 1, prob = 1/(1+exp(1/2-X)))),
                 X = X,
                 fold = unlist(lapply(1:10,function(iL){rep(iL,n/10)})))

## compute auc
auc(labels = dt$Y, predictions = dt$X, direction = ">")

## compute auc after 10-fold cross-validation
auc(labels = dt$Y, prediction = dt$X, fold = dt$fold, observation = 1:NROW(dt))

}
\references{
Erin LeDell, Maya Petersen, and Mark van der Laan (2015). \bold{Computationally efficient confidence intervals for cross-validated area under the ROC curve estimates}. \emph{Electron J Stat.} 9(1):1583–1607. \cr
}
