% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4-BuyseTest-summary.R
\docType{methods}
\name{S4BuyseTest-summary}
\alias{S4BuyseTest-summary}
\alias{summary,S4BuyseTest-method}
\title{Summary Method for Class "S4BuyseTest"}
\usage{
\S4method{summary}{S4BuyseTest}(
  object,
  print = TRUE,
  percentage = TRUE,
  statistic = NULL,
  conf.level = NULL,
  strata = if (length(object@level.strata) == 1) {     "global" } else {     NULL },
  type.display = 1,
  digit = c(2, 4, 5),
  ...
)
}
\arguments{
\item{object}{output of \code{\link{BuyseTest}}}

\item{print}{[logical] Should the table be displayed?.}

\item{percentage}{[logical] Should the percentage of pairs of each type be displayed ? Otherwise the number of pairs is displayed.}

\item{statistic}{[character] the statistic summarizing the pairwise comparison:
\code{"netBenefit"} displays the net benefit, as described in Buyse (2010) and Peron et al. (2016)),
\code{"winRatio"} displays the win ratio, as described in Wang et al. (2016),
\code{"favorable"} displays the proportion in favor of the treatment (also called Mann-Whitney parameter), as described in Fay et al. (2018).
\code{"unfavorable"} displays the proportion in favor of the control.
Default value read from \code{BuyseTest.options()}.}

\item{conf.level}{[numeric] confidence level for the confidence intervals.
Default value read from \code{BuyseTest.options()}.}

\item{strata}{[character vector] the name of the strata to be displayed. Can also be \code{"global"} to display the average over all strata.}

\item{type.display}{[numeric or character] the results/summary statistics to be displayed.
Either an integer indicating refering to a type of display in \code{BuyseTest.options()}
or the name of the column to be output (e.g. \code{c("strata","Delta","p.value")}).}

\item{digit}{[integer vector] the number of digit to use for printing the counts and the delta.}

\item{...}{arguments to be passed to \code{\link{S4BuyseTest-confint}}}
}
\description{
Summarize the results from the \code{\link{BuyseTest}} function.
}
\details{
\bold{Content of the output} \cr
The "results" table in the output show the result of the GPC at each endpoint, as well as its contribution to the global statistics.
More precisely, the column:
\itemize{
  \item \code{endpoint} lists the endpoints, by order of priority.
  \item \code{threshold} lists the threshold associated to each endpoint.
  \item \code{total} lists the total number of pairs to be analyzed at the current priority.
  \item \code{total(\%)} lists the total percentage of pairs to be analyzed at the current priority.
  \item \code{favorable} lists the number of pairs classified in favor of the treatment at the current priority.
  \item \code{favorable(\%)} lists the number of pairs classified in favor of the treatment at the current priority.
  \item \code{unfavorable} lists the number of pairs classified in favor of the control at the current priority.
  \item \code{unfavorable(\%)} lists the percentage of pairs classified in favor of the control at the current priority.
  \item \code{neutral} lists the number of pairs classified as neutral at the current priority.
  \item \code{neutral(\%)} lists the percentage of pairs classified as neutral at the current priority.
  \item \code{uninf} lists the number of pairs that could not be classified at the current priority (due to missing values/censoring).
  \item \code{uninf(\%)} lists the percentage of pairs that could not be classified at the current priority (due to missing values/censoring).
  \item \code{delta} lists the value of the statistic (i.e. net benefit or win ratio) computed on the pairs analyzed at the current priority only.
  \item \code{Delta} lists the value of the statistic (i.e. net benefit or win ratio) computed on all the pairs analyzed up to the current priority.
  \item \code{Delta(\%)} lists the  net benefit or win ratio fraction (i.e. statistic up to the current priority divided by the final statistic).
  \item \code{information(\%)} lists the information fraction (i.e. number of favorable and unfavorable pairs up to the current priority divided by the final number of favorable and unfavorable pairs).
  \item \code{CI} Confidence interval for the value of \code{Delta} (performed independently at each priority, no adjustment for multiple comparison).
  \item \code{p.value} p-value for the test \code{Delta=0} (performed independently at each priority, no adjustment for multiple comparison).
  \item \code{resampling} number of samples used to compute the confidence intervals or p-values from permutations or bootstrap samples.
Only displayed if some bootstrap samples have been discarded, for example, they did not lead to sample any case or control.
}
Note: when using the Peron scoring rule or a correction for uninformative pairs, the columns \code{total}, \code{favorable}, \code{unfavorable}, \code{neutral}, and \code{uninf} are computing by summing the contribution of the pairs. This may lead to a decimal value.

\bold{Statistical inference} \cr
When the interest is in obtaining p-values, we recommand the use of a permutation test.
However, when using a permutation test confidence intervals are not displayed in the summary.
This is because there is no (to the best of our knowledge) straightforward way to obtain good confidence intervals with permutations. 
An easy way consist in using the quantiles of the permutation distribution and then shift by the point estimate of the statistic.
This is what is output by \code{\link{S4BuyseTest-confint}}.
However this approach leads to a much too high coverage when the null hypothesis is false.
The limits of the confidence interval can also end up being outside of the interval of definition of the statistic
(e.g. outside [-1,1] for the proportion in favor of treatment).
Therefore, for obtaining confidence intervals, we recommand the boostrap method or the u-statistic method.

\bold{Win ratio} \cr
For the win ratio, the proposed implementation enables the use of thresholds and endpoints that are not time to events
as well as the correction proposed in Peron et al. (2016) to account for censoring. 
These development have not been examined by Wang et al. (2016), or in other papers (to the best of our knowledge).
They are only provided here by implementation convenience.

\bold{Competing risks} \cr
In presence of competing risks, looking at the net benefit/win ratio computed with respect to the event of interest
will likely not give a full picture of the difference between the two groups.
For instance a treatment may decrease the risk of the event of interest (i.e. increase the net benefit for this event)
by increasing the risk of the competing event. If the competing event is death, this is not desirable. It is therefore advised to
taking into consideration the risk of the competing event, e.g. by re-running BuyseTest where cause 1 and 2 have been inverted.
}
\examples{
library(data.table)

dt <- simBuyseTest(1e2, n.strata = 3)

 \dontrun{
 BT <- BuyseTest(treatment ~ TTE(eventtime, status = status) + Bin(toxicity), data=dt)
 }
 \dontshow{
 BT <- BuyseTest(treatment ~ TTE(eventtime, status = status) + Bin(toxicity), data=dt, n.resampling = 10, trace = 0)
 }
 summary(BT)
 summary(BT, percentage = FALSE)
 summary(BT, statistic = "winRatio")

}
\references{
On the GPC procedure: Marc Buyse (2010). \bold{Generalized pairwise comparisons of prioritized endpoints in the two-sample problem}. \emph{Statistics in Medicine} 29:3245-3257 \cr
On the win ratio: D. Wang, S. Pocock (2016). \bold{A win ratio approach to comparing continuous non-normal outcomes in clinical trials}. \emph{Pharmaceutical Statistics} 15:238-245 \cr
On the Mann-Whitney parameter: Fay, Michael P. et al (2018). \bold{Causal estimands and confidence intervals asscoaited with Wilcoxon-Mann-Whitney tests in randomized experiments}. \emph{Statistics in Medicine} 37:2923-2937 \
}
\seealso{
\code{\link{BuyseTest}} for performing a generalized pairwise comparison. \cr
  \code{\link{S4BuyseTest-class}} for a presentation of the \code{S4BuyseTest} object. \cr
  \code{\link{S4BuyseTest-confint}} to output confidence interval and p-values in a matrix format.
}
\author{
Brice Ozenne
}
\keyword{S4BuyseTest-method}
\keyword{summary}
