% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-setGeneric.R, R/S4-BuyseTest-get.R
\name{getIid}
\alias{getIid}
\alias{S4BuyseTest-getIid}
\alias{getIid,S4BuyseTest-method}
\title{Extract the H-decomposition of the Estimator}
\usage{
getIid(
  object,
  endpoint = NULL,
  statistic = NULL,
  cumulative = TRUE,
  normalize = TRUE,
  type = "all",
  cluster = NULL
)

\S4method{getIid}{S4BuyseTest}(
  object,
  endpoint = NULL,
  statistic = NULL,
  cumulative = TRUE,
  normalize = TRUE,
  type = "all",
  cluster = NULL
)
}
\arguments{
\item{object}{an \R object of class \code{\linkS4class{S4BuyseTest}}, i.e., output of \code{\link{BuyseTest}}}

\item{endpoint}{[character] for which endpoint(s) the H-decomposition should be output?
If \code{NULL} returns the sum of the H-decomposition over all endpoints.}

\item{statistic}{[character] statistic relative to which the H-decomposition should be output.}

\item{cumulative}{[logical] should the influence function be cumulated over endpoints?
Otherwise display the contribution of each endpoint.}

\item{normalize}{[logical] if \code{TRUE} the iid is centered and multiplied by the sample size.
Otherwise not.}

\item{type}{[character] type of iid to be output.
Can be only for the nuisance parameters (\code{"nuisance"}),
or for the u-statistic given the nuisance parameters (\code{"u-statistic"}),
or both.}

\item{cluster}{[numeric vector] return the H-decomposition aggregated by cluster.}
}
\description{
Extract the H-decomposition of the GPC estimator.
}
\seealso{
\code{\link{BuyseTest}} for performing a generalized pairwise comparison. \cr
\code{\link{S4BuyseTest-summary}} for a more detailed presentation of the \code{S4BuyseTest} object.
}
\author{
Brice Ozenne
}
\keyword{S4BuyseTest-method}
