% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuyseMultComp.R
\name{BuyseMultComp}
\alias{BuyseMultComp}
\title{Adjustment for Multiple Comparisons}
\usage{
BuyseMultComp(
  object,
  cluster = NULL,
  linfct = NULL,
  rhs = NULL,
  endpoint = NULL,
  statistic = NULL,
  conf.level = NULL,
  alternative = NULL,
  transformation = NULL,
  ...
)
}
\arguments{
\item{object}{A BuyseTest object or a list of BuyseTest objects. All objects should contain the same endpoints.}

\item{cluster}{[character] name of the variable identifying the observations in the dataset used by each BuyseTest model.
Only relevant when using a list of BuyseTest objects to correctly combine the influence functions.
If NULL, then it is assumed that the BuyseTest objects correspond to different groups of individuals.}

\item{linfct}{[numeric matrix] a contrast matrix of size the number of endpoints times the number of BuyseTest models.}

\item{rhs}{[numeric vector] the values for which the test statistic should be tested against. Should have the same number of rows as \code{linfct}.}

\item{endpoint}{[character or numeric vector] the endpoint(s) to be considered.}

\item{statistic}{[character] the statistic summarizing the pairwise comparison:
\code{"netBenefit"} displays the net benefit, as described in Buyse (2010) and Peron et al. (2016)),
\code{"winRatio"} displays the win ratio, as described in Wang et al. (2016),
\code{"favorable"} displays the proportion in favor of the treatment (also called Mann-Whitney parameter), as described in Fay et al. (2018).
\code{"unfavorable"} displays the proportion in favor of the control.
Default value read from \code{BuyseTest.options()}.}

\item{conf.level}{[numeric] confidence level for the confidence intervals.
Default value read from \code{BuyseTest.options()}.}

\item{alternative}{[character] the type of alternative hypothesis: \code{"two.sided"}, \code{"greater"}, or \code{"less"}.
Default value read from \code{BuyseTest.options()}.}

\item{transformation}{[logical]  should the CI be computed on the logit scale / log scale for the net benefit / win ratio and backtransformed.
Otherwise they are computed without any transformation.
Default value read from \code{BuyseTest.options()}. Not relevant when using permutations or percentile bootstrap.}

\item{...}{argument passsed to the function \code{transformCIBP} of the riskRegression package.}
}
\description{
Adjustment p-values and confidence estimated via GPC for multiple comparisons.
}
\details{
Simulateneous confidence intervals and adjusted p-values are computed using a single-step max-test approach via the function \code{transformCIBP} of the riskRegression package.
}
\examples{
## simulate data
set.seed(10)
df.data <- simBuyseTest(1e2, n.strata = 3)
df.data$id <- paste0("Id",1:NROW(df.data))

## adjustment over endpoints
ff1 <- treatment ~ TTE(eventtime, status = status, threshold = 0.1)
ff2 <- update(ff1, .~. + cont(score, threshold = 1))
BT2 <- BuyseTest(ff2, data= df.data, trace = FALSE)

## (require riskRegression >= 2021.10.04 to match)
confint(BT2) ## not adjusted
BuyseMultComp(BT2, endpoint = 1:2) ## adjusted

## adjustment strata
BT1a <- BuyseTest(treatment ~ TTE(eventtime, status = status, threshold = 0.1),
                 data= df.data[strata == "a",], trace = FALSE)
BT1b <- BuyseTest(treatment ~ TTE(eventtime, status = status, threshold = 0.1),
                 data= df.data[strata == "b",], trace = FALSE)
BT1c <- BuyseTest(treatment ~ TTE(eventtime, status = status, threshold = 0.1),
                 data= df.data[strata == "c",], trace = FALSE)
rbind(a = confint(BT1a), b = confint(BT1b), c = confint(BT1c)) ## not adjusted
BuyseMultComp(list(a = BT1a, b = BT1b, c = BT1c))
BuyseMultComp(list(a = BT1a, b = BT1b, c = BT1c), cluster = "id")
}
