library(C50)
data(churn)

treeModel <- C5.0(x = churnTrain[,-20], y=churnTrain$churn)
print(summary(treeModel))
print(table(predict(treeModel, churnTrain[,-20]), churnTrain$churn))

costs <- matrix(c(0, 1, 5, 0), nrow=2)
rownames(costs) <- colnames(costs) <- levels(churnTrain$churn)
treeModelCost <- C5.0(x=churnTrain[,-20], y=churnTrain$churn, costs=costs)
print(summary(treeModelCost))
print(table(predict(treeModelCost, churnTrain[,-20]), churnTrain$churn))

# This is the string generated by makeCostFile
print(treeModelCost$cost)

# These two are both the same as "costs"
print(identical(costs, treeModelCost$costs))
print(identical(costs, treeModelCost$costMatrix))
print(treeModelCost$costs)


classes <- predict(treeModelCost, churnTrain[,-20])
probs <- predict(treeModelCost, churnTrain[,-20], type = "prob")[,1]
classes2 <- factor(ifelse(probs >= .5,
                          levels(churnTrain$churn)[1],
                          levels(churnTrain$churn)[2]),
                   levels =  levels(churnTrain$churn))
