/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.neptuneinc.cadstat.ui.DataPlotDialog;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

public class LinearRegression
extends DataPlotDialog {
    private String modelString;
    private JPanel analysisOptsPane;
    public JRadioButton binomDistButton;
    private JCheckBox confIntervals;
    private JLabel confLabel;
    private JSpinner confLevelSpinner;
    private JCheckBox cookDist;
    private JComboBox dependentComboBox;
    private JLabel dependentLabel;
    private ButtonGroup distButtonGroup;
    private JPanel distPane;
    private JLabel independentLabel;
    private JList independentList;
    private JScrollPane independentScrollPane;
    private JCheckBox influencePlot;
    private JPanel leftPane;
    private JPanel leftRightPane;
    private JPanel modelEqPane;
    private JScrollPane modelEqScrollPane;
    private JTextArea modelEqTextArea;
    public JRadioButton normDistButton;
    private JCheckBox normalQQ;
    private JPanel plotOptsPane;
    private JPanel plotPane;
    public JRadioButton poisDistButton;
    private JCheckBox resVsFit;
    private JLabel resultLabel;
    private JTextField resultName;
    private JPanel rightPane;
    private JCheckBox rmIntercept;
    private JComboBox sampleSizeComboBox;
    private JLabel sampleSizeLabel;
    private JPanel savePanel;
    private JCheckBox saveResults;
    private JCheckBox scaleLoc;
    private JPanel varPane;

    @Override
    protected void initCustom() {
        this.initComponents();
        this.getPlotPane().add((Component)this.plotPane, "Center");
        this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinearRegression.this.datasetComboBoxActionPerformed(e);
            }
        });
        this.refreshVariableList();
        this.refreshValidity();
        this.updateModelEquation();
        if (System.getProperty("os.name").contains("Windows")) {
            this.setSize(580, 648);
        }
    }

    private void datasetComboBoxActionPerformed(ActionEvent e) {
        this.refreshVariableList();
        this.refreshValidity();
        this.updateModelEquation();
    }

    public void refreshDistValidity() {
        Enumeration<AbstractButton> distButtonEnum = this.distButtonGroup.getElements();
        while (distButtonEnum.hasMoreElements()) {
            distButtonEnum.nextElement().setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0);
        }
    }

    public void refreshModelValidity() {
        this.refreshDistValidity();
        this.refreshVariableListValidity();
    }

    public void updateModelEquation() {
        if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0) {
            String modelEq = this.dependentComboBox.getSelectedItem() + " ~ " + RUtils.toString(this.independentList.getSelectedValues(), " + ", "");
            this.modelEqTextArea.setText(modelEq);
            if (this.binomDistButton.isSelected()) {
                this.setModelString(this.sampleSizeComboBox.getSelectedItem() + "," + this.dependentComboBox.getSelectedItem() + "," + RUtils.toString(this.independentList.getSelectedValues(), ",", ""));
            } else {
                this.setModelString(modelEq);
            }
        } else {
            this.setModelString(null);
            this.modelEqTextArea.setText(null);
        }
    }

    public void refreshVariableListValidity() {
        this.dependentLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.dependentComboBox.getItemCount() > 0);
        this.dependentComboBox.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.dependentComboBox.getItemCount() > 0);
        this.independentLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.independentList.getModel().getSize() > 0);
        this.independentList.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.independentList.getModel().getSize() > 0);
        this.sampleSizeLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.sampleSizeComboBox.getItemCount() > 0 && this.binomDistButton.isSelected());
        this.sampleSizeComboBox.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.sampleSizeComboBox.getItemCount() > 0 && this.binomDistButton.isSelected());
    }

    public void refreshVariableList() {
        if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0) {
            Vector nonFactors = null;
            Vector<String> onePlusNonFactors = null;
            Vector colNames = null;
            try {
                nonFactors = RUtils.nonFactors(this.getDatasetPane().getSelectedDataset());
                onePlusNonFactors = new Vector<String>(nonFactors.size() + 1);
                onePlusNonFactors.add("1");
                onePlusNonFactors.addAll(nonFactors);
                colNames = RUtils.colnamesVector(this.getDatasetPane().getSelectedDataset());
                this.dependentComboBox.setModel(new DefaultComboBoxModel(nonFactors));
                this.sampleSizeComboBox.setModel(new DefaultComboBoxModel(onePlusNonFactors));
                if (colNames != null) {
                    this.independentList.setListData(colNames);
                } else {
                    this.independentList.removeAll();
                }
                if (this.dependentComboBox.getItemCount() > 0) {
                    this.dependentComboBox.setSelectedIndex(0);
                }
                if (this.sampleSizeComboBox.getItemCount() > 0) {
                    this.sampleSizeComboBox.setSelectedIndex(0);
                }
            }
            catch (REngineException ex) {
                Logger.getLogger(LinearRegression.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (REXPMismatchException ex) {
                Logger.getLogger(LinearRegression.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.dependentComboBox.removeAllItems();
            this.independentList.setModel(new DefaultListModel());
            this.sampleSizeComboBox.removeAllItems();
        }
        this.refreshValidity();
    }

    public void refreshConfLevelValidity() {
        this.confLabel.setEnabled(this.confIntervals.isSelected());
        this.confLevelSpinner.setEnabled(this.confIntervals.isSelected());
    }

    public void refreshSubmitButtonValidity() {
        this.getSubmitButton().setEnabled(!this.independentList.isSelectionEmpty());
    }

    public void refreshValidity() {
        this.refreshModelValidity();
        this.refreshConfLevelValidity();
        this.refreshSubmitButtonValidity();
    }

    private void initComponents() {
        this.distButtonGroup = new ButtonGroup();
        this.plotPane = new JPanel();
        this.modelEqPane = new JPanel();
        this.modelEqScrollPane = new JScrollPane();
        this.modelEqTextArea = new JTextArea();
        this.leftRightPane = new JPanel();
        this.leftPane = new JPanel();
        this.distPane = new JPanel();
        this.normDistButton = new JRadioButton();
        this.poisDistButton = new JRadioButton();
        this.binomDistButton = new JRadioButton();
        this.varPane = new JPanel();
        this.dependentLabel = new JLabel();
        this.dependentComboBox = new JComboBox();
        this.independentLabel = new JLabel();
        this.independentScrollPane = new JScrollPane();
        this.independentList = new JList();
        this.sampleSizeLabel = new JLabel();
        this.sampleSizeComboBox = new JComboBox();
        this.rightPane = new JPanel();
        this.plotOptsPane = new JPanel();
        this.resVsFit = new JCheckBox();
        this.normalQQ = new JCheckBox();
        this.scaleLoc = new JCheckBox();
        this.cookDist = new JCheckBox();
        this.influencePlot = new JCheckBox();
        this.analysisOptsPane = new JPanel();
        this.rmIntercept = new JCheckBox();
        this.confIntervals = new JCheckBox();
        this.confLabel = new JLabel();
        this.confLevelSpinner = new JSpinner();
        this.savePanel = new JPanel();
        this.saveResults = new JCheckBox();
        this.resultLabel = new JLabel();
        this.resultName = new JTextField();
        this.modelEqPane.setBorder(BorderFactory.createTitledBorder("Model Equation"));
        this.modelEqTextArea.setColumns(20);
        this.modelEqTextArea.setEditable(false);
        this.modelEqTextArea.setLineWrap(true);
        this.modelEqTextArea.setRows(2);
        this.modelEqTextArea.setWrapStyleWord(true);
        this.modelEqScrollPane.setViewportView(this.modelEqTextArea);
        GroupLayout modelEqPaneLayout = new GroupLayout(this.modelEqPane);
        this.modelEqPane.setLayout(modelEqPaneLayout);
        modelEqPaneLayout.setHorizontalGroup(modelEqPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modelEqPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.modelEqScrollPane, -1, 665, Short.MAX_VALUE).addContainerGap()));
        modelEqPaneLayout.setVerticalGroup(modelEqPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modelEqPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.modelEqScrollPane, -2, -1, -2).addContainerGap(13, Short.MAX_VALUE)));
        this.leftRightPane.setLayout(new GridLayout(1, 2, 5, 0));
        this.distPane.setBorder(BorderFactory.createTitledBorder("Distribution"));
        this.distButtonGroup.add(this.normDistButton);
        this.normDistButton.setSelected(true);
        this.normDistButton.setText("Normal");
        this.normDistButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.distButtonGroup.add(this.poisDistButton);
        this.poisDistButton.setText("Poisson");
        this.poisDistButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.distButtonGroup.add(this.binomDistButton);
        this.binomDistButton.setText("Binomial");
        this.binomDistButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.binomDistButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LinearRegression.this.binomDistButtonStateChanged(evt);
            }
        });
        GroupLayout distPaneLayout = new GroupLayout(this.distPane);
        this.distPane.setLayout(distPaneLayout);
        distPaneLayout.setHorizontalGroup(distPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(distPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.normDistButton).addGap(18, 18, 18).addComponent(this.poisDistButton).addGap(18, 18, 18).addComponent(this.binomDistButton).addContainerGap(16, Short.MAX_VALUE)));
        distPaneLayout.setVerticalGroup(distPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(distPaneLayout.createSequentialGroup().addContainerGap().addGroup(distPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.normDistButton).addComponent(this.poisDistButton).addComponent(this.binomDistButton)).addContainerGap(16, Short.MAX_VALUE)));
        this.varPane.setBorder(BorderFactory.createTitledBorder("Variables"));
        this.dependentLabel.setText("Dependent:");
        this.dependentComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinearRegression.this.dependentComboBoxActionPerformed(evt);
            }
        });
        this.independentLabel.setText("Independent:");
        this.independentList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                LinearRegression.this.independentListValueChanged(evt);
            }
        });
        this.independentScrollPane.setViewportView(this.independentList);
        this.sampleSizeLabel.setText("Sample Size:");
        GroupLayout varPaneLayout = new GroupLayout(this.varPane);
        this.varPane.setLayout(varPaneLayout);
        varPaneLayout.setHorizontalGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addContainerGap().addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.sampleSizeLabel).addComponent(this.independentLabel).addComponent(this.dependentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.independentScrollPane, -1, 182, Short.MAX_VALUE).addComponent(this.sampleSizeComboBox, GroupLayout.Alignment.TRAILING, 0, 182, Short.MAX_VALUE).addComponent(this.dependentComboBox, GroupLayout.Alignment.TRAILING, 0, 182, Short.MAX_VALUE)).addContainerGap()));
        varPaneLayout.setVerticalGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addContainerGap().addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dependentComboBox, -2, -1, -2).addComponent(this.dependentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.independentLabel).addComponent(this.independentScrollPane, -1, 266, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sampleSizeComboBox, -2, -1, -2).addComponent(this.sampleSizeLabel)).addContainerGap()));
        GroupLayout leftPaneLayout = new GroupLayout(this.leftPane);
        this.leftPane.setLayout(leftPaneLayout);
        leftPaneLayout.setHorizontalGroup(leftPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.distPane, -1, -1, Short.MAX_VALUE).addComponent(this.varPane, -1, -1, Short.MAX_VALUE));
        leftPaneLayout.setVerticalGroup(leftPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(leftPaneLayout.createSequentialGroup().addComponent(this.distPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.varPane, -1, -1, Short.MAX_VALUE)));
        this.leftRightPane.add(this.leftPane);
        this.plotOptsPane.setBorder(BorderFactory.createTitledBorder("Diagnostic Plots"));
        this.resVsFit.setText("Residual vs. Fitted");
        this.normalQQ.setText("Normal Q-Q Plot");
        this.scaleLoc.setText("Scale-Location Plot");
        this.cookDist.setText("Cook's Distance Plot");
        this.influencePlot.setText("Influence Plot");
        GroupLayout plotOptsPaneLayout = new GroupLayout(this.plotOptsPane);
        this.plotOptsPane.setLayout(plotOptsPaneLayout);
        plotOptsPaneLayout.setHorizontalGroup(plotOptsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotOptsPaneLayout.createSequentialGroup().addContainerGap().addGroup(plotOptsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resVsFit).addComponent(this.normalQQ).addComponent(this.scaleLoc).addComponent(this.cookDist).addComponent(this.influencePlot)).addContainerGap(122, Short.MAX_VALUE)));
        plotOptsPaneLayout.setVerticalGroup(plotOptsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotOptsPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.resVsFit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.normalQQ).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scaleLoc).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cookDist).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.influencePlot).addContainerGap(-1, Short.MAX_VALUE)));
        this.analysisOptsPane.setBorder(BorderFactory.createTitledBorder("Analysis Options"));
        this.rmIntercept.setText("Remove Intercept");
        this.confIntervals.setText("Compute Confidence Intervals");
        this.confIntervals.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LinearRegression.this.confIntervalsStateChanged(evt);
            }
        });
        this.confLabel.setText("Confidence Level:");
        this.confLevelSpinner.setModel(new SpinnerNumberModel(0.95, 0.01, 0.99, 0.01));
        GroupLayout analysisOptsPaneLayout = new GroupLayout(this.analysisOptsPane);
        this.analysisOptsPane.setLayout(analysisOptsPaneLayout);
        analysisOptsPaneLayout.setHorizontalGroup(analysisOptsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(analysisOptsPaneLayout.createSequentialGroup().addContainerGap().addGroup(analysisOptsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(analysisOptsPaneLayout.createSequentialGroup().addComponent(this.confIntervals).addContainerGap(31, Short.MAX_VALUE)).addComponent(this.rmIntercept))).addGroup(analysisOptsPaneLayout.createSequentialGroup().addGap(59, 59, 59).addComponent(this.confLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.confLevelSpinner, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        analysisOptsPaneLayout.setVerticalGroup(analysisOptsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(analysisOptsPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.rmIntercept).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.confIntervals).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(analysisOptsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.confLabel).addComponent(this.confLevelSpinner, -2, -1, -2)).addContainerGap(13, Short.MAX_VALUE)));
        this.savePanel.setBorder(BorderFactory.createTitledBorder("Results"));
        this.saveResults.setText("Save R Results?");
        this.saveResults.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.saveResults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinearRegression.this.saveResultsActionPerformed(evt);
            }
        });
        this.resultLabel.setText("Result Name:");
        this.resultLabel.setEnabled(false);
        this.resultName.setColumns(12);
        this.resultName.setEnabled(false);
        GroupLayout savePanelLayout = new GroupLayout(this.savePanel);
        this.savePanel.setLayout(savePanelLayout);
        savePanelLayout.setHorizontalGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(savePanelLayout.createSequentialGroup().addGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(savePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.saveResults)).addGroup(savePanelLayout.createSequentialGroup().addGap(56, 56, 56).addComponent(this.resultLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultName, -1, 137, Short.MAX_VALUE))).addContainerGap()));
        savePanelLayout.setVerticalGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(savePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.saveResults).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resultLabel).addComponent(this.resultName, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout rightPaneLayout = new GroupLayout(this.rightPane);
        this.rightPane.setLayout(rightPaneLayout);
        rightPaneLayout.setHorizontalGroup(rightPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.plotOptsPane, -1, -1, Short.MAX_VALUE).addComponent(this.analysisOptsPane, -1, -1, Short.MAX_VALUE).addComponent(this.savePanel, -1, -1, Short.MAX_VALUE));
        rightPaneLayout.setVerticalGroup(rightPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rightPaneLayout.createSequentialGroup().addComponent(this.plotOptsPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.analysisOptsPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.savePanel, -2, -1, -2)));
        this.leftRightPane.add(this.rightPane);
        GroupLayout plotPaneLayout = new GroupLayout(this.plotPane);
        this.plotPane.setLayout(plotPaneLayout);
        plotPaneLayout.setHorizontalGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, plotPaneLayout.createSequentialGroup().addContainerGap().addGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.leftRightPane, GroupLayout.Alignment.LEADING, -1, 701, Short.MAX_VALUE).addComponent(this.modelEqPane, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        plotPaneLayout.setVerticalGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotPaneLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.modelEqPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.leftRightPane, -1, 476, Short.MAX_VALUE).addContainerGap()));
        this.setTitle("Linear Regression");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 832) / 2, (screenSize.height - 828) / 2, 832, 828);
    }

    private void confIntervalsStateChanged(ChangeEvent evt) {
        this.refreshValidity();
    }

    private void binomDistButtonStateChanged(ChangeEvent evt) {
        this.sampleSizeLabel.setEnabled(this.binomDistButton.isSelected());
        this.sampleSizeComboBox.setEnabled(this.binomDistButton.isSelected());
        this.updateModelEquation();
    }

    private void dependentComboBoxActionPerformed(ActionEvent evt) {
        this.updateModelEquation();
    }

    private void independentListValueChanged(ListSelectionEvent evt) {
        this.updateModelEquation();
        this.refreshSubmitButtonValidity();
    }

    private void saveResultsActionPerformed(ActionEvent evt) {
        this.resultLabel.setEnabled(this.saveResults.isSelected());
        this.resultName.setEnabled(this.saveResults.isSelected());
        if (this.saveResults.isSelected()) {
            this.resultName.setText("my.glm.fit");
        } else {
            this.resultName.setText(null);
        }
    }

    @Override
    protected void submitButtonAction() {
        String distFamily = "NULL";
        if (this.normDistButton.isSelected()) {
            distFamily = "'gaussian'";
        } else if (this.poisDistButton.isSelected()) {
            distFamily = "'poisson'";
        } else if (this.binomDistButton.isSelected()) {
            distFamily = "'binomial'";
        }
        String cmd = "glm.JGR(my.data=" + (this.getDatasetPane().getDatasetComboBox() != null && this.getDatasetPane().getDatasetComboBox().getSelectedIndex() != -1 ? this.getDatasetPane().getSelectedDataset() : "NULL") + ", subset1.name=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : RUtils.getStringValue(this.getFactorSelectionPane1().getSelectedFactor())) + ", subset1.val=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'") + ")") + ", subset2.name=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : RUtils.getStringValue(this.getFactorSelectionPane2().getSelectedFactor())) + ", subset2.val=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'") + ")") + ", my.formula=" + "'" + this.getModelString() + "'" + ", my.family=" + distFamily + ", iCI=" + String.valueOf(this.confIntervals.isSelected()).toUpperCase() + (this.confIntervals.isSelected() ? ", conf.level=" + (Double)this.confLevelSpinner.getValue() : "") + ", iDiag.1=" + String.valueOf(this.resVsFit.isSelected()).toUpperCase() + ", iDiag.2=" + String.valueOf(this.normalQQ.isSelected()).toUpperCase() + ", iDiag.3=" + String.valueOf(this.scaleLoc.isSelected()).toUpperCase() + ", iDiag.4=" + String.valueOf(this.cookDist.isSelected()).toUpperCase() + ", iInfluence=" + String.valueOf(this.influencePlot.isSelected()).toUpperCase() + ", iRmIntercept=" + String.valueOf(this.rmIntercept.isSelected()).toUpperCase() + ", saveLMName=" + "'" + this.resultName.getText() + "'" + ")";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    @Override
    protected void helpButtonAction() {
        String cmd = "CADStat.help('glm.JGR')";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    public String getModelString() {
        return this.modelString;
    }

    public void setModelString(String modelString) {
        this.modelString = modelString;
    }

    @Override
    public void windowActivated(WindowEvent e) {
        Object dep = this.dependentComboBox.getSelectedItem();
        int[] indepIndices = this.independentList.getSelectedIndices();
        this.getDatasetPane().refreshDatasetComboBox();
        this.dependentComboBox.setSelectedItem(dep);
        this.independentList.setSelectedIndices(indepIndices);
        this.updateModelEquation();
        this.refreshFactorSelectionPanes();
        this.refreshValidity();
    }
}

