/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.DataLoader;
import org.rosuda.JGR.JGR;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

public class DataMergeDialog
extends JDialog
implements WindowListener {
    private Map<JComboBox, List<JComboBox>> datasetVariableMap;
    private JButton browse1Button;
    private JButton browse2Button;
    private JPanel buttonPane;
    private JComboBox by11ComboBox;
    private JLabel by11Label;
    private JComboBox by12ComboBox;
    private JLabel by12Label;
    private JComboBox by13ComboBox;
    private JLabel by13Label;
    private JComboBox by21ComboBox;
    private JLabel by21Label;
    private JComboBox by22ComboBox;
    private JLabel by22Label;
    private JComboBox by23ComboBox;
    private JLabel by23Label;
    private JCheckBox byall1CheckBox;
    private JCheckBox byall2CheckBox;
    private JButton cancelButton;
    private JComboBox dataset1ComboBox;
    private JLabel dataset1Label;
    private JPanel dataset1Pane;
    private JComboBox dataset2ComboBox;
    private JLabel dataset2Label;
    private JPanel dataset2Pane;
    private JPanel datasetPane;
    private JButton helpButton;
    private JTextField nameText;
    private JButton outputBrowse;
    private JTextField rNameText;
    private JLabel rSaveLabel;
    private JCheckBox saveCheck;
    private JLabel saveLabel;
    private JPanel saveLeftPane;
    private JPanel savePane;
    private JPanel saveRightPane;
    private JCheckBox sortCheck;
    private JButton submitButton;
    private JTextField suffix1;
    private JLabel suffix1Label;
    private JTextField suffix2;
    private JLabel suffix2Label;

    public DataMergeDialog() {
        this.initComponents();
        this.getRootPane().setDefaultButton(this.submitButton);
        this.addWindowListener(this);
        this.initCustom();
        this.refreshDatasetLists();
        this.refreshVariableLists();
        this.refreshValidity();
        try {
            Object[] datasets = RUtils.getDatasetList();
            for (JComboBox datasetComboBox : this.getDatasetVariableMap().keySet()) {
                GUIUtils.updateDataList(datasetComboBox, datasets);
            }
        }
        catch (REngineException ex) {
            Logger.getLogger(DataMergeDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (REXPMismatchException ex) {
            Logger.getLogger(DataMergeDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void initCustom() {
        this.setDatasetVariableMap(new HashMap<JComboBox, List<JComboBox>>(2));
        this.getDatasetVariableMap().put(this.getDataset1ComboBox(), new ArrayList(3));
        this.getDatasetVariableMap().put(this.getDataset2ComboBox(), new ArrayList(3));
        this.getDatasetVariableMap().get(this.getDataset1ComboBox()).add(this.getBy11ComboBox());
        this.getDatasetVariableMap().get(this.getDataset1ComboBox()).add(this.getBy12ComboBox());
        this.getDatasetVariableMap().get(this.getDataset1ComboBox()).add(this.getBy13ComboBox());
        this.getDatasetVariableMap().get(this.getDataset2ComboBox()).add(this.getBy21ComboBox());
        this.getDatasetVariableMap().get(this.getDataset2ComboBox()).add(this.getBy22ComboBox());
        this.getDatasetVariableMap().get(this.getDataset2ComboBox()).add(this.getBy23ComboBox());
        for (JComboBox jComboBox : this.getDatasetVariableMap().keySet()) {
            jComboBox.setModel(new DefaultComboBoxModel());
        }
        for (List list : this.getDatasetVariableMap().values()) {
            for (JComboBox b : list) {
                b.setModel(new DefaultComboBoxModel());
            }
        }
        if (System.getProperty("os.name").contains("Windows")) {
            this.setSize(800, 380);
        }
    }

    private void refreshValidity() {
        this.refreshDatasetValidity();
        this.refreshSubmitButtonValidity();
    }

    public void refreshDatasetValidity() {
        for (JComboBox datasetComboBox : this.getDatasetVariableMap().keySet()) {
            if (datasetComboBox == null) continue;
            datasetComboBox.setEnabled(datasetComboBox.getModel().getSize() > 0);
        }
    }

    public void refreshSubmitButtonValidity() {
        boolean datasetValid = true;
        boolean variableValid = false;
        for (JComboBox datasetComboBox : this.getDatasetVariableMap().keySet()) {
            datasetValid = datasetValid && datasetComboBox != null && datasetComboBox.getSelectedIndex() != -1;
        }
        ArrayList<List<JComboBox>> variableComboBoxes = new ArrayList<List<JComboBox>>(this.getDatasetVariableMap().values());
        int m = ((List)variableComboBoxes.get(0)).size();
        for (int j = 0; j < m; ++j) {
            boolean variableSetValid = true;
            for (List list : variableComboBoxes) {
                variableSetValid = variableSetValid && ((JComboBox)list.get(j)).getSelectedIndex() != -1;
            }
            variableValid = variableValid || variableSetValid;
        }
        boolean valid = datasetValid && variableValid;
        this.submitButton.setEnabled(valid);
    }

    public void refreshDatasetLists() {
        Object var11 = this.getBy11ComboBox().getSelectedItem();
        Object var12 = this.getBy12ComboBox().getSelectedItem();
        Object var13 = this.getBy13ComboBox().getSelectedItem();
        Object var21 = this.getBy21ComboBox().getSelectedItem();
        Object var22 = this.getBy22ComboBox().getSelectedItem();
        Object var23 = this.getBy23ComboBox().getSelectedItem();
        try {
            Object[] datasets = RUtils.getDatasetList();
            for (JComboBox datasetComboBox : this.getDatasetVariableMap().keySet()) {
                GUIUtils.updateDataList(datasetComboBox, datasets);
            }
        }
        catch (REngineException ex) {
            Logger.getLogger(DataMergeDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (REXPMismatchException ex) {
            Logger.getLogger(DataMergeDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.getBy11ComboBox().setSelectedItem(var11);
        this.getBy12ComboBox().setSelectedItem(var12);
        this.getBy13ComboBox().setSelectedItem(var13);
        this.getBy21ComboBox().setSelectedItem(var21);
        this.getBy22ComboBox().setSelectedItem(var22);
        this.getBy23ComboBox().setSelectedItem(var23);
        this.refreshValidity();
    }

    public void refreshVariableLists() {
        for (JComboBox datasetComboBox : this.getDatasetVariableMap().keySet()) {
            this.refreshVariableLists(datasetComboBox);
        }
        this.refreshValidity();
    }

    public void refreshVariableLists(JComboBox datasetComboBox) {
        if (datasetComboBox != null && datasetComboBox.getSelectedIndex() != -1) {
            String datasetName = datasetComboBox.getSelectedItem().toString();
            String[] colnames = null;
            try {
                colnames = RUtils.colnames(datasetName);
                for (JComboBox varList : this.getDatasetVariableMap().get(datasetComboBox)) {
                    if (colnames != null && colnames.length > 0) {
                        Object selectedItem = varList.getSelectedItem();
                        varList.setModel(new DefaultComboBoxModel<String>(colnames));
                        varList.setSelectedItem(selectedItem);
                        continue;
                    }
                    varList.removeAllItems();
                }
            }
            catch (REngineException ex) {
                Logger.getLogger(DataMergeDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (REXPMismatchException ex) {
                Logger.getLogger(DataMergeDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public JPanel getDataset1Pane() {
        return this.dataset1Pane;
    }

    public void setDataset1Pane(JPanel dataset1Pane) {
        this.dataset1Pane = dataset1Pane;
    }

    public JPanel getDataset2Pane() {
        return this.dataset1Pane;
    }

    public void setDataset2Pane(JPanel dataset2Pane) {
        this.dataset2Pane = dataset2Pane;
    }

    public JPanel getSavePane() {
        return this.savePane;
    }

    public void setSavePane(JPanel savePane) {
        this.savePane = savePane;
    }

    public JComboBox getDataset1ComboBox() {
        return this.dataset1ComboBox;
    }

    public JComboBox getDataset2ComboBox() {
        return this.dataset2ComboBox;
    }

    public JComboBox getBy11ComboBox() {
        return this.by11ComboBox;
    }

    public JComboBox getBy12ComboBox() {
        return this.by12ComboBox;
    }

    public JComboBox getBy13ComboBox() {
        return this.by13ComboBox;
    }

    public JComboBox getBy21ComboBox() {
        return this.by21ComboBox;
    }

    public JComboBox getBy22ComboBox() {
        return this.by22ComboBox;
    }

    public JComboBox getBy23ComboBox() {
        return this.by23ComboBox;
    }

    private int setTextUsingFileChooser(JTextField textField, int mode) {
        String workingDir = null;
        try {
            workingDir = RUtils.evalAsString("getwd()");
        }
        catch (REngineException ex) {
            Logger.getLogger(DataMergeDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (REXPMismatchException ex) {
            Logger.getLogger(DataMergeDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        JFileChooser fc = new JFileChooser(workingDir);
        fc.setMultiSelectionEnabled(false);
        fc.setFileSelectionMode(mode);
        int fcReturnState = fc.showOpenDialog(this);
        if (fcReturnState == 0) {
            textField.setText(fc.getSelectedFile().toString().replace('\\', '/'));
        }
        return fcReturnState;
    }

    private void initComponents() {
        this.datasetPane = new JPanel();
        this.dataset1Pane = new JPanel();
        this.dataset1Label = new JLabel();
        this.dataset1ComboBox = new JComboBox();
        this.browse1Button = new JButton();
        this.by11Label = new JLabel();
        this.by11ComboBox = new JComboBox();
        this.by12Label = new JLabel();
        this.by12ComboBox = new JComboBox();
        this.by13Label = new JLabel();
        this.by13ComboBox = new JComboBox();
        this.byall1CheckBox = new JCheckBox();
        this.suffix1Label = new JLabel();
        this.suffix1 = new JTextField();
        this.dataset2Pane = new JPanel();
        this.dataset2Label = new JLabel();
        this.dataset2ComboBox = new JComboBox();
        this.browse2Button = new JButton();
        this.by21Label = new JLabel();
        this.by21ComboBox = new JComboBox();
        this.by22Label = new JLabel();
        this.by22ComboBox = new JComboBox();
        this.by23Label = new JLabel();
        this.by23ComboBox = new JComboBox();
        this.byall2CheckBox = new JCheckBox();
        this.suffix2Label = new JLabel();
        this.suffix2 = new JTextField();
        this.savePane = new JPanel();
        this.saveLeftPane = new JPanel();
        this.sortCheck = new JCheckBox();
        this.rSaveLabel = new JLabel();
        this.rNameText = new JTextField();
        this.saveRightPane = new JPanel();
        this.saveCheck = new JCheckBox();
        this.saveLabel = new JLabel();
        this.nameText = new JTextField();
        this.outputBrowse = new JButton();
        this.buttonPane = new JPanel();
        this.cancelButton = new JButton();
        this.submitButton = new JButton();
        this.helpButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Data Merge");
        this.setMinimumSize(new Dimension(30, 30));
        this.datasetPane.setLayout(new GridLayout(1, 2, 5, 0));
        this.dataset1Pane.setBorder(BorderFactory.createTitledBorder("Dataset 1"));
        this.dataset1Pane.setMinimumSize(new Dimension(30, 30));
        this.dataset1Label.setLabelFor(this.dataset1ComboBox);
        this.dataset1Label.setText("Dataset 1:");
        this.dataset1ComboBox.setMinimumSize(new Dimension(120, 24));
        this.dataset1ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.dataset1ComboBoxActionPerformed(evt);
            }
        });
        this.browse1Button.setText("Browse...");
        this.browse1Button.setMargin(new Insets(0, 5, 0, 5));
        this.browse1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.browse1ButtonActionPerformed(evt);
            }
        });
        this.by11Label.setLabelFor(this.by11ComboBox);
        this.by11Label.setText("Variable 1:");
        this.by11Label.setToolTipText("Pick variable from Dataset 1 that corresponds to Variable 1 in Dataset 2.  Necessary if column names do not match.");
        this.by11ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.by11ComboBoxActionPerformed(evt);
            }
        });
        this.by12Label.setLabelFor(this.by12ComboBox);
        this.by12Label.setText("Variable 2:");
        this.by12Label.setToolTipText("Pick variable from Dataset 1 that corresponds to Variable 2 in Dataset 2.  Necessary if column names do not match.");
        this.by12ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.by12ComboBoxActionPerformed(evt);
            }
        });
        this.by13Label.setLabelFor(this.by13ComboBox);
        this.by13Label.setText("Variable 3:");
        this.by13Label.setToolTipText("Pick variable from Dataset 1 that corresponds to Variable 3 in Dataset 2.  Necessary if column names do not match.");
        this.by13ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.by13ComboBoxActionPerformed(evt);
            }
        });
        this.byall1CheckBox.setSelected(true);
        this.byall1CheckBox.setText("By All");
        this.byall1CheckBox.setToolTipText("If selected, then all rows in Dataset 1 will be included, even if there is no corresponding row in Dataset 2.");
        this.byall1CheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.suffix1Label.setText("Suffix: ");
        this.suffix1Label.setToolTipText("If column names match in Dataset 1 and 2, then this suffix will be added to the column name for Dataset 1.");
        this.suffix1.setText(".1");
        GroupLayout dataset1PaneLayout = new GroupLayout(this.dataset1Pane);
        this.dataset1Pane.setLayout(dataset1PaneLayout);
        dataset1PaneLayout.setHorizontalGroup(dataset1PaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataset1PaneLayout.createSequentialGroup().addContainerGap().addGroup(dataset1PaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataset1PaneLayout.createSequentialGroup().addComponent(this.dataset1Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataset1ComboBox, 0, 230, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browse1Button)).addGroup(dataset1PaneLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(dataset1PaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.by12Label).addComponent(this.by11Label).addComponent(this.by13Label).addComponent(this.suffix1Label)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dataset1PaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.by12ComboBox, 0, 325, Short.MAX_VALUE).addComponent(this.by11ComboBox, 0, 325, Short.MAX_VALUE).addComponent(this.by13ComboBox, 0, 325, Short.MAX_VALUE).addComponent(this.byall1CheckBox).addComponent(this.suffix1, -2, 80, -2)))).addContainerGap()));
        dataset1PaneLayout.setVerticalGroup(dataset1PaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataset1PaneLayout.createSequentialGroup().addGroup(dataset1PaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dataset1Label).addComponent(this.dataset1ComboBox, -2, -1, -2).addComponent(this.browse1Button)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dataset1PaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.by11Label).addComponent(this.by11ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dataset1PaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.by12Label).addComponent(this.by12ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dataset1PaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.by13Label).addComponent(this.by13ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.byall1CheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dataset1PaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.suffix1, -2, -1, -2).addComponent(this.suffix1Label)).addContainerGap()));
        this.datasetPane.add(this.dataset1Pane);
        this.dataset2Pane.setBorder(BorderFactory.createTitledBorder("Dataset 2"));
        this.dataset2Pane.setMinimumSize(new Dimension(30, 30));
        this.dataset2Label.setText("Dataset 2:");
        this.dataset2ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.dataset2ComboBoxActionPerformed(evt);
            }
        });
        this.browse2Button.setText("Browse...");
        this.browse2Button.setMargin(new Insets(0, 5, 0, 5));
        this.browse2Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.browse2ButtonActionPerformed(evt);
            }
        });
        this.by21Label.setLabelFor(this.by21ComboBox);
        this.by21Label.setText("Variable 1:");
        this.by21Label.setToolTipText("Pick variable from Dataset 2 that corresponds to Variable 1 in Dataset 1.  Necessary if column names do not match.");
        this.by21ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.by21ComboBoxActionPerformed(evt);
            }
        });
        this.by22Label.setLabelFor(this.by22ComboBox);
        this.by22Label.setText("Variable 2:");
        this.by22Label.setToolTipText("Pick Variable from Dataset 2 that corresponds to Variable2 from Dataset 1.  Necessary if column names do not match.");
        this.by22ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.by22ComboBoxActionPerformed(evt);
            }
        });
        this.by23Label.setLabelFor(this.by23ComboBox);
        this.by23Label.setText("Variable 3:");
        this.by23Label.setToolTipText("Pick variable from Dataset 2 that corresponds to Variable 3 in Dataset 1.  Necessary if column names do not match.");
        this.by23ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.by23ComboBoxActionPerformed(evt);
            }
        });
        this.byall2CheckBox.setSelected(true);
        this.byall2CheckBox.setText("By All");
        this.byall2CheckBox.setToolTipText("If selected, then all rows in Dataset 2 will be included, even if there is no corresponding row in Dataset 1.");
        this.byall2CheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.suffix2Label.setText("Suffix:");
        this.suffix2Label.setToolTipText("If column names match in Dataset 1 and 2, then this suffix will be added to the column name for Dataset 2.");
        this.suffix2.setText(".2");
        GroupLayout dataset2PaneLayout = new GroupLayout(this.dataset2Pane);
        this.dataset2Pane.setLayout(dataset2PaneLayout);
        dataset2PaneLayout.setHorizontalGroup(dataset2PaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataset2PaneLayout.createSequentialGroup().addContainerGap().addGroup(dataset2PaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataset2PaneLayout.createSequentialGroup().addComponent(this.dataset2Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataset2ComboBox, 0, 230, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browse2Button).addContainerGap()).addGroup(dataset2PaneLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(dataset2PaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.by22Label).addComponent(this.by21Label).addComponent(this.by23Label).addComponent(this.suffix2Label)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dataset2PaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.suffix2, -2, 80, -2).addGroup(dataset2PaneLayout.createSequentialGroup().addGroup(dataset2PaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.by22ComboBox, 0, 325, Short.MAX_VALUE).addComponent(this.by21ComboBox, 0, 325, Short.MAX_VALUE).addComponent(this.by23ComboBox, 0, 325, Short.MAX_VALUE).addComponent(this.byall2CheckBox)).addContainerGap()))))));
        dataset2PaneLayout.setVerticalGroup(dataset2PaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, dataset2PaneLayout.createSequentialGroup().addGroup(dataset2PaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dataset2Label).addComponent(this.dataset2ComboBox, -2, -1, -2).addComponent(this.browse2Button)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dataset2PaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.by21Label).addComponent(this.by21ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dataset2PaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.by22Label).addComponent(this.by22ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dataset2PaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.by23Label).addComponent(this.by23ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.byall2CheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dataset2PaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.suffix2, -2, -1, -2).addComponent(this.suffix2Label)).addContainerGap(20, Short.MAX_VALUE)));
        this.datasetPane.add(this.dataset2Pane);
        this.savePane.setBorder(BorderFactory.createTitledBorder("Save Options"));
        this.savePane.setLayout(new GridLayout(1, 0));
        this.sortCheck.setText("Sort Output Data");
        this.sortCheck.setToolTipText("If selected, merged data will be sorted based on the columns used for merging.  If not selected, rows remain in order of dataset 1, with non-intersecting rows coming at the end, dataset 1 before dataset 2.");
        this.sortCheck.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rSaveLabel.setText("Local Name:");
        this.rSaveLabel.setToolTipText("This sets the variable name in R (and thus how the name will appear in the dataset lists).");
        this.rNameText.setText("mergedData");
        GroupLayout saveLeftPaneLayout = new GroupLayout(this.saveLeftPane);
        this.saveLeftPane.setLayout(saveLeftPaneLayout);
        saveLeftPaneLayout.setHorizontalGroup(saveLeftPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(saveLeftPaneLayout.createSequentialGroup().addContainerGap().addGroup(saveLeftPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sortCheck).addGroup(saveLeftPaneLayout.createSequentialGroup().addComponent(this.rSaveLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rNameText, -1, 332, Short.MAX_VALUE))).addContainerGap()));
        saveLeftPaneLayout.setVerticalGroup(saveLeftPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(saveLeftPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.sortCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(saveLeftPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rSaveLabel).addComponent(this.rNameText, -2, -1, -2)).addContainerGap(14, Short.MAX_VALUE)));
        this.savePane.add(this.saveLeftPane);
        this.saveCheck.setSelected(true);
        this.saveCheck.setText("Save to File");
        this.saveCheck.setToolTipText("If checked, the merged dataset will be written out as a tab-delimited text file to the location specified below.");
        this.saveCheck.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.saveCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.saveCheckActionPerformed(evt);
            }
        });
        this.saveLabel.setText("Filename:");
        this.saveLabel.setToolTipText("Name (and path) under which to save the merged file.  A .txt extension is recommended, since the output will be tab-delimited text.");
        this.nameText.setText("mergedData.txt");
        this.outputBrowse.setText("Browse...");
        this.outputBrowse.setMargin(new Insets(0, 5, 0, 5));
        this.outputBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.outputBrowseActionPerformed(evt);
            }
        });
        GroupLayout saveRightPaneLayout = new GroupLayout(this.saveRightPane);
        this.saveRightPane.setLayout(saveRightPaneLayout);
        saveRightPaneLayout.setHorizontalGroup(saveRightPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(saveRightPaneLayout.createSequentialGroup().addGroup(saveRightPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(saveRightPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.saveCheck)).addGroup(saveRightPaneLayout.createSequentialGroup().addGap(55, 55, 55).addComponent(this.saveLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameText, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputBrowse))).addContainerGap(-1, Short.MAX_VALUE)));
        saveRightPaneLayout.setVerticalGroup(saveRightPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(saveRightPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.saveCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(saveRightPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveLabel).addComponent(this.nameText, -2, -1, -2).addComponent(this.outputBrowse)).addContainerGap(-1, Short.MAX_VALUE)));
        this.savePane.add(this.saveRightPane);
        this.buttonPane.setLayout(new FlowLayout(1, 10, 5));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMargin(new Insets(0, 10, 0, 10));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPane.add(this.cancelButton);
        this.submitButton.setText("Submit");
        this.submitButton.setMargin(new Insets(0, 10, 0, 10));
        this.submitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.submitButtonActionPerformed(evt);
            }
        });
        this.buttonPane.add(this.submitButton);
        this.helpButton.setText("Help");
        this.helpButton.setMargin(new Insets(0, 10, 0, 10));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.helpButtonActionPerformed(evt);
            }
        });
        this.buttonPane.add(this.helpButton);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.datasetPane, -1, 966, Short.MAX_VALUE).addComponent(this.savePane, -1, 966, Short.MAX_VALUE).addComponent(this.buttonPane, -1, 966, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.datasetPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.savePane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonPane, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void saveCheckActionPerformed(ActionEvent evt) {
        this.saveLabel.setEnabled(this.saveCheck.isSelected());
        this.nameText.setEnabled(this.saveCheck.isSelected());
        this.outputBrowse.setEnabled(this.saveCheck.isSelected());
    }

    private void outputBrowseActionPerformed(ActionEvent evt) {
        this.setTextUsingFileChooser(this.nameText, 0);
    }

    private void by23ComboBoxActionPerformed(ActionEvent evt) {
        this.refreshValidity();
    }

    private void by22ComboBoxActionPerformed(ActionEvent evt) {
        this.refreshValidity();
    }

    private void by21ComboBoxActionPerformed(ActionEvent evt) {
        this.refreshValidity();
    }

    private void by13ComboBoxActionPerformed(ActionEvent evt) {
        this.refreshValidity();
    }

    private void by12ComboBoxActionPerformed(ActionEvent evt) {
        this.refreshValidity();
    }

    private void by11ComboBoxActionPerformed(ActionEvent evt) {
        this.refreshValidity();
    }

    private void dataset2ComboBoxActionPerformed(ActionEvent evt) {
        this.refreshVariableLists(this.dataset2ComboBox);
    }

    private void browse2ButtonActionPerformed(ActionEvent evt) {
        DataLoader loader = new DataLoader();
        String dataName = loader.getDataName();
        JGR.MAINRCONSOLE.toBack();
        if (dataName == null || dataName.length() > 0) {
            // empty if block
        }
    }

    private void browse1ButtonActionPerformed(ActionEvent evt) {
        DataLoader loader = new DataLoader();
        String dataName = loader.getDataName();
        JGR.MAINRCONSOLE.toBack();
        if (dataName == null || dataName.length() > 0) {
            // empty if block
        }
    }

    private void dataset1ComboBoxActionPerformed(ActionEvent evt) {
        this.refreshVariableLists(this.dataset1ComboBox);
    }

    private void submitButtonActionPerformed(ActionEvent evt) {
        String cmd = "datamerge.JGR(x=" + (this.getDataset1ComboBox() != null && this.getDataset1ComboBox().getSelectedIndex() != -1 ? this.getDataset1ComboBox().getSelectedItem() : "NULL") + ", y=" + (this.getDataset2ComboBox() != null && this.getDataset2ComboBox().getSelectedIndex() != -1 ? this.getDataset2ComboBox().getSelectedItem() : "NULL") + ", by11=" + GUIUtils.getSelectedItemR(this.by11ComboBox) + ", by12=" + GUIUtils.getSelectedItemR(this.by12ComboBox) + ", by13=" + GUIUtils.getSelectedItemR(this.by13ComboBox) + ", by21=" + GUIUtils.getSelectedItemR(this.by21ComboBox) + ", by22=" + GUIUtils.getSelectedItemR(this.by22ComboBox) + ", by23=" + GUIUtils.getSelectedItemR(this.by23ComboBox) + ", all.x=" + GUIUtils.getBooleanValueR(this.byall1CheckBox) + ", all.y=" + GUIUtils.getBooleanValueR(this.byall2CheckBox) + ", suffixes=" + "c(" + RUtils.getStringValue(this.suffix1.getText()) + "," + RUtils.getStringValue(this.suffix2.getText()) + ")" + ", rName=" + RUtils.getStringValue(this.rNameText.getText()) + ", sort=" + GUIUtils.getBooleanValueR(this.sortCheck) + ", writeout=" + GUIUtils.getBooleanValueR(this.saveCheck) + ", outName=" + RUtils.getStringValue(this.nameText.getText()) + ")";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    private void helpButtonActionPerformed(ActionEvent evt) {
        String cmd = "CADStat.help('datamerge.JGR')";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.refreshValidity();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.refreshDatasetLists();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public Map<JComboBox, List<JComboBox>> getDatasetVariableMap() {
        return this.datasetVariableMap;
    }

    public void setDatasetVariableMap(Map<JComboBox, List<JComboBox>> datasetVariableMap) {
        this.datasetVariableMap = datasetVariableMap;
    }
}

