/*
 * BxPlot.java
 *
 * Created on September 27, 2005, 6:33 PM
 */
package org.neptuneinc.cadstat.plots;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.neptuneinc.cadstat.prefs.PreferencesManager;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;
import CADStat.java.plots.SubsetFormatter;

/**
 *
 * @author  Pasha Minallah
 */
public class BxPlot extends JDialog implements WindowListener
{
  /** Creates new form BoxPlot */
  public BxPlot()
  {
    this.initComponents();

    this.addWindowListener(this);

    datasetPane.getDatasetLabel().setText("Active Dataset:");
    datasetPane.getDatasetComboBox().addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        datasetComboBoxActionPerformed(e);
      }
    });
    datasetPane.refreshDatasetComboBox();
    this.refreshVariableListValidity();
    this.refreshGroupByComponentValidity();
    this.refreshSubmitButtonValidity();

    this.getRootPane().setDefaultButton(submitButton);
  }

  private void datasetComboBoxActionPerformed(ActionEvent evt)
  {
    this.refreshVariableList();
    this.factorSubsetPane.setDataset(datasetPane.getSelectedDataset());
    this.refreshGroupByComponentValidity();
    this.refreshSubmitButtonValidity();
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        plotTypeGroup = new javax.swing.ButtonGroup();
        datasetContainerPane = new javax.swing.JPanel();
        datasetPane = new org.neptuneinc.cadstat.ui.DatasetPane();
        datasetSeparator = new javax.swing.JSeparator();
        midPane = new javax.swing.JPanel();
        leftPane = new javax.swing.JPanel();
        varPane = new javax.swing.JPanel();
        resultLabel = new javax.swing.JLabel();
        resultComboBox = new javax.swing.JComboBox();
        groupByPane = new javax.swing.JPanel();
        enableGroupByCheckBox = new javax.swing.JCheckBox();
        factorSubsetPane = new org.neptuneinc.cadstat.ui.FactorSubsetPane();
        rightPane = new javax.swing.JPanel();
        plotTypePane = new javax.swing.JPanel();
        originalPlotTypeRadioButton = new javax.swing.JRadioButton();
        logPlotTypeRadioButton = new javax.swing.JRadioButton();
        bothPlotTypeRadioButton = new javax.swing.JRadioButton();
        plotOptionsPane = new javax.swing.JPanel();
        sampleSizes = new javax.swing.JCheckBox();
        rotateXLabCheckBox = new javax.swing.JCheckBox();
        horizontal = new javax.swing.JCheckBox();
        plotLabelsPane = new javax.swing.JPanel();
        plotTitleLabel = new javax.swing.JLabel();
        plotTitle = new javax.swing.JTextField();
        yAxisLabel = new javax.swing.JLabel();
        yAxis = new javax.swing.JTextField();
        buttonSeparator = new javax.swing.JSeparator();
        buttonPane = new javax.swing.JPanel();
        cancelButton = new javax.swing.JButton();
        submitButton = new javax.swing.JButton();
        helpButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Boxplot");

        datasetContainerPane.add(datasetPane);

        midPane.setLayout(new java.awt.GridLayout(1, 2, 5, 0));

        varPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Variables"));

        resultLabel.setText("Result:");

        javax.swing.GroupLayout varPaneLayout = new javax.swing.GroupLayout(varPane);
        varPane.setLayout(varPaneLayout);
        varPaneLayout.setHorizontalGroup(
            varPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, varPaneLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(resultLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(resultComboBox, 0, 216, Short.MAX_VALUE)
                .addContainerGap())
        );
        varPaneLayout.setVerticalGroup(
            varPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(varPaneLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(varPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(resultLabel)
                    .addComponent(resultComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(14, Short.MAX_VALUE))
        );

        groupByPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Group By"));

        enableGroupByCheckBox.setText("Enable Grouping");
        enableGroupByCheckBox.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                enableGroupByCheckBoxStateChanged(evt);
            }
        });

        javax.swing.GroupLayout groupByPaneLayout = new javax.swing.GroupLayout(groupByPane);
        groupByPane.setLayout(groupByPaneLayout);
        groupByPaneLayout.setHorizontalGroup(
            groupByPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(groupByPaneLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(groupByPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, groupByPaneLayout.createSequentialGroup()
                        .addGap(12, 12, 12)
                        .addComponent(factorSubsetPane, javax.swing.GroupLayout.DEFAULT_SIZE, 277, Short.MAX_VALUE))
                    .addComponent(enableGroupByCheckBox))
                .addContainerGap())
        );
        groupByPaneLayout.setVerticalGroup(
            groupByPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(groupByPaneLayout.createSequentialGroup()
                .addComponent(enableGroupByCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(factorSubsetPane, javax.swing.GroupLayout.DEFAULT_SIZE, 219, Short.MAX_VALUE)
                .addContainerGap())
        );

        javax.swing.GroupLayout leftPaneLayout = new javax.swing.GroupLayout(leftPane);
        leftPane.setLayout(leftPaneLayout);
        leftPaneLayout.setHorizontalGroup(
            leftPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(varPane, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addComponent(groupByPane, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        leftPaneLayout.setVerticalGroup(
            leftPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(leftPaneLayout.createSequentialGroup()
                .addComponent(varPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(groupByPane, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        midPane.add(leftPane);

        plotTypePane.setBorder(javax.swing.BorderFactory.createTitledBorder("Plot Type"));

        plotTypeGroup.add(originalPlotTypeRadioButton);
        originalPlotTypeRadioButton.setText("Original");

        plotTypeGroup.add(logPlotTypeRadioButton);
        logPlotTypeRadioButton.setText("Log");

        plotTypeGroup.add(bothPlotTypeRadioButton);
        bothPlotTypeRadioButton.setSelected(true);
        bothPlotTypeRadioButton.setText("Both");

        javax.swing.GroupLayout plotTypePaneLayout = new javax.swing.GroupLayout(plotTypePane);
        plotTypePane.setLayout(plotTypePaneLayout);
        plotTypePaneLayout.setHorizontalGroup(
            plotTypePaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(plotTypePaneLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(plotTypePaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(originalPlotTypeRadioButton)
                    .addComponent(logPlotTypeRadioButton)
                    .addComponent(bothPlotTypeRadioButton))
                .addContainerGap(208, Short.MAX_VALUE))
        );
        plotTypePaneLayout.setVerticalGroup(
            plotTypePaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(plotTypePaneLayout.createSequentialGroup()
                .addComponent(originalPlotTypeRadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(logPlotTypeRadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(bothPlotTypeRadioButton)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        plotOptionsPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Plot Options"));

        sampleSizes.setText("Sample Sizes");

        rotateXLabCheckBox.setText("Rotate X-Axis Labels");

        horizontal.setText("Horizontal Boxplot");
        horizontal.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                horizontalActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout plotOptionsPaneLayout = new javax.swing.GroupLayout(plotOptionsPane);
        plotOptionsPane.setLayout(plotOptionsPaneLayout);
        plotOptionsPaneLayout.setHorizontalGroup(
            plotOptionsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(plotOptionsPaneLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(plotOptionsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(sampleSizes)
                    .addComponent(rotateXLabCheckBox)
                    .addComponent(horizontal))
                .addContainerGap(95, Short.MAX_VALUE))
        );
        plotOptionsPaneLayout.setVerticalGroup(
            plotOptionsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, plotOptionsPaneLayout.createSequentialGroup()
                .addComponent(horizontal)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(sampleSizes)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(rotateXLabCheckBox)
                .addContainerGap())
        );

        plotLabelsPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Plot Labels"));

        plotTitleLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        plotTitleLabel.setLabelFor(plotTitle);
        plotTitleLabel.setText("Plot Title");

        plotTitle.setColumns(10);
        plotTitle.setText("Boxplot");

        yAxisLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        yAxisLabel.setLabelFor(yAxis);
        yAxisLabel.setText("Result-Axis");

        yAxis.setColumns(10);
        yAxis.setText("Y");

        javax.swing.GroupLayout plotLabelsPaneLayout = new javax.swing.GroupLayout(plotLabelsPane);
        plotLabelsPane.setLayout(plotLabelsPaneLayout);
        plotLabelsPaneLayout.setHorizontalGroup(
            plotLabelsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(plotLabelsPaneLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(plotLabelsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(plotLabelsPaneLayout.createSequentialGroup()
                        .addComponent(plotTitleLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(plotTitle, javax.swing.GroupLayout.DEFAULT_SIZE, 179, Short.MAX_VALUE))
                    .addGroup(plotLabelsPaneLayout.createSequentialGroup()
                        .addComponent(yAxisLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(yAxis, javax.swing.GroupLayout.DEFAULT_SIZE, 179, Short.MAX_VALUE)))
                .addContainerGap())
        );

        plotLabelsPaneLayout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {plotTitleLabel, yAxisLabel});

        plotLabelsPaneLayout.setVerticalGroup(
            plotLabelsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(plotLabelsPaneLayout.createSequentialGroup()
                .addGroup(plotLabelsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(plotTitleLabel)
                    .addComponent(plotTitle, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(plotLabelsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(yAxisLabel)
                    .addComponent(yAxis, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(14, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout rightPaneLayout = new javax.swing.GroupLayout(rightPane);
        rightPane.setLayout(rightPaneLayout);
        rightPaneLayout.setHorizontalGroup(
            rightPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(plotTypePane, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addComponent(plotOptionsPane, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addComponent(plotLabelsPane, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        rightPaneLayout.setVerticalGroup(
            rightPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(rightPaneLayout.createSequentialGroup()
                .addComponent(plotTypePane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(plotOptionsPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(plotLabelsPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        midPane.add(rightPane);

        cancelButton.setText("Cancel");
        cancelButton.setMargin(new java.awt.Insets(0, 10, 0, 10));
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        buttonPane.add(cancelButton);

        submitButton.setText("Submit");
        submitButton.setMargin(new java.awt.Insets(0, 10, 0, 10));
        submitButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                submitButtonActionPerformed(evt);
            }
        });
        buttonPane.add(submitButton);

        helpButton.setText("Help");
        helpButton.setMargin(new java.awt.Insets(0, 10, 0, 10));
        helpButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                helpButtonActionPerformed(evt);
            }
        });
        buttonPane.add(helpButton);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(datasetContainerPane, javax.swing.GroupLayout.DEFAULT_SIZE, 680, Short.MAX_VALUE)
            .addComponent(datasetSeparator, javax.swing.GroupLayout.DEFAULT_SIZE, 680, Short.MAX_VALUE)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(midPane, javax.swing.GroupLayout.DEFAULT_SIZE, 656, Short.MAX_VALUE)
                .addContainerGap())
            .addComponent(buttonSeparator, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 680, Short.MAX_VALUE)
            .addComponent(buttonPane, javax.swing.GroupLayout.DEFAULT_SIZE, 680, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(datasetContainerPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(datasetSeparator, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(midPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(buttonSeparator, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(buttonPane, javax.swing.GroupLayout.PREFERRED_SIZE, 44, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
  this.dispose();
}//GEN-LAST:event_cancelButtonActionPerformed

private void submitButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_submitButtonActionPerformed
  PreferencesManager prefsManager = new PreferencesManager();

  try
  {
    prefsManager.importPreferences();
  }
  catch (Exception ex)
  {
    Logger.getLogger(BxPlot.class.getName()).log(Level.INFO, null, ex);
  }

  String plotType = null;

  if (originalPlotTypeRadioButton.isSelected())
  {
    plotType = "original";
  }
  else if (logPlotTypeRadioButton.isSelected())
  {
    plotType = "log";
  }
  else if (bothPlotTypeRadioButton.isSelected())
  {
    plotType = "both";
  }

  String cmd = "bxplot.JGR("
    + "my.data=" + datasetPane.getSelectedDataset()
    + ", result=" + GUIUtils.getSelectedItemR(resultComboBox)
    + ", group.name=" + (enableGroupByCheckBox.isSelected() ? RUtils.getStringValue(factorSubsetPane.getSelectedFactor()) : "NULL")
    + ", group.val=" + (enableGroupByCheckBox.isSelected() && this.factorSubsetPane.getFactorValueList().isSelectionEmpty() ? "NULL" : SubsetFormatter.formatSubset(this.factorSubsetPane.getSelectedFactorValues()))
    + ", subset1.name=" + "NULL"
    + ", subset1.val=" + "NULL"
    + ", subset2.name=" + "NULL"
    + ", subset2.val=" + "NULL"
    + ", main=" + RUtils.getStringValue(plotTitle.getText())
    + ", result.lab=" + RUtils.getStringValue(yAxis.getText())
    + ", plot.type=" + RUtils.getStringValue(plotType)
    + ", horizontal=" + GUIUtils.getBooleanValueR(horizontal)
    + ", iSampleSize=" + GUIUtils.getBooleanValueR(sampleSizes)
    + ", names.rot=" + GUIUtils.getBooleanValueR(rotateXLabCheckBox)
    + ", " + prefsManager.getCadstatPreferences().toString()
    + ")";
  JGR.MAINRCONSOLE.execute(cmd, true);
}//GEN-LAST:event_submitButtonActionPerformed

private void helpButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_helpButtonActionPerformed
  String cmd = "CADStat.help('boxplot.JGR')";
  JGR.MAINRCONSOLE.execute(cmd, true);
}//GEN-LAST:event_helpButtonActionPerformed

private void enableGroupByCheckBoxStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_enableGroupByCheckBoxStateChanged
  this.refreshGroupByComponentValidity();
  this.refreshSubmitButtonValidity();
}//GEN-LAST:event_enableGroupByCheckBoxStateChanged

private void horizontalActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_horizontalActionPerformed
  this.refreshSampleSizes();
}//GEN-LAST:event_horizontalActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton bothPlotTypeRadioButton;
    private javax.swing.JPanel buttonPane;
    private javax.swing.JSeparator buttonSeparator;
    private javax.swing.JButton cancelButton;
    private javax.swing.JPanel datasetContainerPane;
    private org.neptuneinc.cadstat.ui.DatasetPane datasetPane;
    private javax.swing.JSeparator datasetSeparator;
    private javax.swing.JCheckBox enableGroupByCheckBox;
    private org.neptuneinc.cadstat.ui.FactorSubsetPane factorSubsetPane;
    private javax.swing.JPanel groupByPane;
    private javax.swing.JButton helpButton;
    private javax.swing.JCheckBox horizontal;
    private javax.swing.JPanel leftPane;
    private javax.swing.JRadioButton logPlotTypeRadioButton;
    private javax.swing.JPanel midPane;
    private javax.swing.JRadioButton originalPlotTypeRadioButton;
    private javax.swing.JPanel plotLabelsPane;
    private javax.swing.JPanel plotOptionsPane;
    private javax.swing.JTextField plotTitle;
    private javax.swing.JLabel plotTitleLabel;
    private javax.swing.ButtonGroup plotTypeGroup;
    private javax.swing.JPanel plotTypePane;
    private javax.swing.JComboBox resultComboBox;
    private javax.swing.JLabel resultLabel;
    private javax.swing.JPanel rightPane;
    private javax.swing.JCheckBox rotateXLabCheckBox;
    private javax.swing.JCheckBox sampleSizes;
    private javax.swing.JButton submitButton;
    private javax.swing.JPanel varPane;
    private javax.swing.JTextField yAxis;
    private javax.swing.JLabel yAxisLabel;
    // End of variables declaration//GEN-END:variables

  public void refreshVariableListValidity()
  {
    resultComboBox.setEnabled(datasetPane.getDatasetComboBox().getItemCount() > 0 && resultComboBox.getItemCount() > 0);
  }

  public void refreshSampleSizes()
  {
    sampleSizes.setSelected(!horizontal.isSelected() && sampleSizes.isSelected());
    //  sampleSizes.setEnabled(!horizontal.isSelected());
  }

  public void refreshVariableList()
  {
    if (datasetPane.getDatasetComboBox().getItemCount() > 0)
    {
      Vector<String> nonFactors = null;

      try
      {
        nonFactors = RUtils.nonFactors(datasetPane.getSelectedDataset());

        resultComboBox.setModel(new DefaultComboBoxModel(nonFactors));

        if (resultComboBox.getItemCount() > 0)
        {
          resultComboBox.setSelectedIndex(0);
        }
      }
      catch (REngineException ex)
      {
        Logger.getLogger(BxPlot.class.getName()).log(Level.SEVERE, null, ex);
      }
      catch (REXPMismatchException ex)
      {
        Logger.getLogger(BxPlot.class.getName()).log(Level.SEVERE, null, ex);
      }
    }
    else
    {
      resultComboBox.removeAllItems();
    }

    this.refreshVariableListValidity();
    this.refreshSubmitButtonValidity();
  }

  public void refreshGroupByComponentValidity()
  {
    JLabel factorLabel = factorSubsetPane.getFactorLabel();
    JComboBox factorComboBox = factorSubsetPane.getFactorComboBox();
    JScrollPane factorValueScrollPane = factorSubsetPane.getFactorValueScrollPane();
    JList factorValueList = factorSubsetPane.getFactorValueList();

    boolean groupByEnabled = enableGroupByCheckBox.isSelected();

    factorLabel.setEnabled(groupByEnabled && factorComboBox.getItemCount() > 0);
    factorComboBox.setEnabled(groupByEnabled && factorComboBox.getItemCount() > 0);
    factorValueScrollPane.setEnabled(groupByEnabled && factorValueList.getModel().getSize() > 0);
    factorValueList.setEnabled(groupByEnabled && factorValueList.getModel().getSize() > 0);
  }

  public void refreshSubmitButtonValidity()
  {
    JComboBox factorComboBox = factorSubsetPane.getFactorComboBox();

    submitButton.setEnabled(datasetPane.getDatasetComboBox().getItemCount() > 0 && resultComboBox.getItemCount() > 0
      && (enableGroupByCheckBox.isSelected() ? factorComboBox.getItemCount() > 0 : true));
  }

  @Override
  public void windowOpened(WindowEvent e)
  {
  }

  @Override
  public void windowClosing(WindowEvent e)
  {
  }

  @Override
  public void windowClosed(WindowEvent e)
  {
  }

  @Override
  public void windowIconified(WindowEvent e)
  {
  }

  @Override
  public void windowDeiconified(WindowEvent e)
  {
  }

  @Override
  public void windowActivated(WindowEvent e)
  {
    Object result = resultComboBox.getSelectedItem();
    Object factor = factorSubsetPane.getFactorComboBox().getSelectedItem();
    int[] factorValueIndices = factorSubsetPane.getFactorValueList().getSelectedIndices();

    datasetPane.refreshDatasetComboBox();
    resultComboBox.setSelectedItem(result);
    factorSubsetPane.getFactorComboBox().setSelectedItem(factor);
    factorSubsetPane.getFactorValueList().setSelectedIndices(factorValueIndices);

    this.refreshVariableListValidity();
    this.refreshGroupByComponentValidity();
    this.refreshSubmitButtonValidity();
  }

  @Override
  public void windowDeactivated(WindowEvent e)
  {
  }
}
