% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carrot_functions.R
\name{compute_weights}
\alias{compute_weights}
\title{Weights of predictors}
\usage{
compute_weights(vari_col, vari)
}
\arguments{
\item{vari_col}{number of predictors}

\item{vari}{set of predictors}
}
\value{
Returns an array of weights of the size \code{vari_col}
}
\description{
Function which computes the weight of each predictor according to the rules of thumb and outputs it into corresponding array
}
\details{
Continuous or categorical numerical variable with more then 5 categories has weight 1, otherwise it has weight \code{n-1} where \code{n} is the number of categories
}
\examples{
#creating data-set with for variables

a<-matrix(NA,nrow=100,ncol=4)

#binary variable

a[,1]=rbinom(100,1,0.3)

#continuous variable

a[,2]=runif(100,0,1)

#categorical numeric with les than 5 categories

a[,3]=t(rmultinom(100,1,c(0.2,0.3,0.5)))\%*\%c(1,2,3)

#categorical numeric with 5 categories

a[,4]=t(rmultinom(100,1,c(0.2,0.3,0.3,0.1,0.1)))\%*\%c(1,2,3,4,5)

#running the function

compute_weights(4,a)
}
\references{
{
\insertRef{ref1}{CARRoT}
}

{
\insertRef{ref2012-18631-001}{CARRoT}
}
}
