% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carrot_functions.R
\name{compute_max_weight}
\alias{compute_max_weight}
\title{Maximum feasible weight of the predictors}
\usage{
compute_max_weight(outi,mode)
}
\arguments{
\item{outi}{set of outcomes}

\item{mode}{indicates the mode: 'linear' (linear regression), 'binary' (logistic regression), 'multin' (multinomial regression)}
}
\value{
returns an integer value of maximum allowed weight multiplied by 10
}
\description{
Function which computes maximal weight (multiplied by the corresponding EPV rule) of a regression according to the rule of thumb applied to the outcome variable. Weight of a regression equals the sum of weights of its predictors.
}
\details{
For continuous outcomes it equals sample size divided by 10, for multinomial it equals the size of the smallest category divided by 10
}
\examples{
#continuous outcomes

compute_max_weight(runif(100,0,1),'linear')

#binary outcomes

compute_max_weight(rbinom(100,1,0.4),'binary')
}
\references{
{
\insertRef{ref1}{CARRoT}
}
}
