% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carrot_functions.R
\name{sum_weights_sub}
\alias{sum_weights_sub}
\title{Cumulative weights of the predictors' subsets}
\usage{
sum_weights_sub(a,m,we,st)
}
\arguments{
\item{a}{an \code{m} x N matrix, containing all possible subsets (N overall) of the size \code{m} of predictors' indices; therefore each column of \code{a} defines a unique subset of the predictors}

\item{m}{number of elements in each subset of indices}

\item{we}{array of weights of the predictors}

\item{st}{a subset of predictors to be always included into a predictive model}
}
\value{
Returns an array of weights for predictors defined by each colun of the matrix \code{a}
}
\description{
Function which computes the sum of predictors' weights for each subset containing a fixed number of predictors
}
\examples{
#all two-element subsets of the set 1:3

a<-combn(3,2)

sum_weights_sub(a,2,c(1,2,1))
}
