% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig_tot_inertia_perm.R
\name{sig.tot.inertia.perm}
\alias{sig.tot.inertia.perm}
\title{Permuted significance of the CA total inertia}
\usage{
sig.tot.inertia.perm(data, B = 1000)
}
\arguments{
\item{data}{Name of the dataset (must be in dataframe format).}

\item{B}{Number of permutations (1000 by default).}
}
\description{
This function allows to calculate the permuted significance of CA total
inertia. Number of permutation set at 1000 by default, but can be increased by
the user.
}
\examples{
data(greenacre_data)

#Returns the frequency distribution histogtam of the permuted total inertia
#(using 100 permutations). The observed total inertia and the 95th percentile
#of the permuted inertia are also displayed for testing the significance
#of the observed total inertia.
sig.tot.inertia.perm(greenacre_data, 100)

}
\seealso{
\code{\link{sig.dim.perm.scree}} , \code{\link{sig.dim.perm}}
}
\keyword{sig.tot.inertia.perm}
