% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdmSubset.R
\name{cdmSubsetCohort}
\alias{cdmSubsetCohort}
\title{Subset a cdm to the individuals in one or more cohorts}
\usage{
cdmSubsetCohort(cdm, cohortTable = "cohort", cohortId = NULL, verbose = FALSE)
}
\arguments{
\item{cdm}{A cdm_reference object}

\item{cohortTable}{Then name of a cohort table in the cdm reference}

\item{cohortId}{IDs of the cohorts that we want to subset from the cohort
table. If NULL (default) all cohorts in cohort table are considered.}

\item{verbose}{Should subset messages be printed? TRUE or FALSE (default)}
}
\value{
A modified cdm_reference with all clinical tables subset
to just the persons in the selected cohorts.
}
\description{
\code{cdmSubset} will return a new cdm object that contains lazy queries pointing
to each of the cdm tables but subset to individuals in a generated cohort.
Since the cdm tables are lazy queries, the subset operation will only be
done when the tables are used. \code{computeQuery} can be used to run the SQL
used to subset a cdm table and store it as a new table in the database.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\dontrun{
library(CDMConnector)
library(dplyr, warn.conflicts = FALSE)

con <- DBI::dbConnect(duckdb::duckdb(), eunomia_dir())

cdm <- cdm_from_con(con, cdm_schema = "main", write_schema = "main")

# generate a cohort
path <- system.file("cohorts2", mustWork = TRUE, package = "CDMConnector")

cohortSet <- readCohortSet(path) \%>\%
  filter(cohort_name == "GIBleed_male")

# subset cdm to persons in the generated cohort
cdm <- generateCohortSet(cdm, cohortSet = cohortSet, name = "gibleed")

cdmGiBleed <- cdmSubsetCohort(cdm, cohortTable = "gibleed")

cdmGiBleed$person \%>\%
  tally()
#> # Source:   SQL [1 x 1]
#> # Database: DuckDB 0.6.1
#>       n
#>   <dbl>
#> 1   237

cdm$person \%>\%
  tally()
#> # Source:   SQL [1 x 1]
#> # Database: DuckDB 0.6.1
#>       n
#>   <dbl>
#> 1  2694


DBI::dbDisconnect(con, shutdown = TRUE)
}
}
