% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reexports-omopgenerics.R
\name{cdm_from_tables}
\alias{cdm_from_tables}
\title{Create a cdm object from local tables}
\usage{
cdm_from_tables(tables, cdm_name, cohort_tables = list(), cdm_version = NULL)
}
\arguments{
\item{tables}{List of tables to be part of the cdm object.}

\item{cdm_name}{Name of the cdm object.}

\item{cohort_tables}{List of tables that contains cohort, cohort_set and
cohort_attrition can be provided as attributes.}

\item{cdm_version}{Version of the cdm_reference}
}
\value{
A \code{cdm_reference} object.
}
\description{
Create a cdm object from local tables
}
\examples{
\dontrun{
library(CDMConnector)

person <- dplyr::tibble(
  person_id = 1, gender_concept_id = 0, year_of_birth = 1990,
  race_concept_id = 0, ethnicity_concept_id = 0
)
observation_period <- dplyr::tibble(
  observation_period_id = 1, person_id = 1,
  observation_period_start_date = as.Date("2000-01-01"),
  observation_period_end_date = as.Date("2025-12-31"),
  period_type_concept_id = 0
)
cdm <- cdm_from_tables(
  tables = list("person" = person, "observation_period" = observation_period),
  cdm_name = "test"
)
}
}
