% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPL.R
\name{summary.CDnetNPL}
\alias{summary.CDnetNPL}
\alias{print.summary.CDnetNPL}
\alias{print.CDnetNPL}
\alias{print.summary.CDnetNPLs}
\title{Summarize Count Data Model with Social Interactions}
\usage{
\method{summary}{CDnetNPL}(object, cov.ctr = list(), Glist, data, ...)

\method{print}{summary.CDnetNPL}(x, ...)

\method{print}{CDnetNPL}(x, ...)

\method{print}{summary.CDnetNPLs}(x, ...)
}
\arguments{
\item{object}{an object of class \code{CDnetNPL}, output of the function \code{\link{CDnetNPL}}.}

\item{cov.ctr}{list of control values for the covariance containing two integers, \code{R} and \code{S}. The covariance summations from \code{0}
to infinity. But the summed elements decreases exponentially. The summations are approximated by summations from \code{0} to \code{R}.
The covariance also requires computing \eqn{\Phi(x) - \Phi(x - 1)}, where \eqn{\Phi} is
the normal'  probability density function. This is done using important sampling, where \code{S} numbers are generated
form the uniform distribution.}

\item{Glist}{the adjacency matrix or list sub-adjacency matrix. If missing make, sure that
the object provided to the function \code{\link{CDnetNPL}} is available in \code{.GlobalEnv} (see detail - codedata section of \code{\link{CDnetNPL}}).}

\item{data}{dataframe containing the explanatory variables. If missing make, sure that
the object provided to the function \code{\link{CDnetNPL}} is available in \code{.GlobalEnv} (see detail - codedata section of \code{\link{CDnetNPL}}).}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class \code{summary.CDnetNPL}, output of the function \code{\link{summary.CDnetNPL}},
class \code{summary.CDnetNPLs}, list of outputs of the function \code{\link{summary.CDnetNPL}}
(when the model is estimated many times to control for the endogeneity)
or class \code{CDnetNPL} of the function \code{\link{CDnetNPL}}.}
}
\value{
A list consisting of:
\item{M}{number of sub-networks.}
\item{n}{number of individuals in each network.}
\item{iteration}{number of iterations performed by the NPL algorithm.}
\item{estimate}{NPL estimator.}
\item{likelihood}{pseudo-likelihood value.}
\item{yb}{ybar (see details), expectation of y.}
\item{Gyb}{average of the expectation of y among friends.}
\item{steps}{step-by-step output as returned by the optimizer.}
\item{cov}{covariance matrix of the estimate.}
\item{meffects}{vector of marginal effects.}
\item{cov.me}{covariance matrix of the marginal effects.}
\item{cov.ctr}{returned value of the control values for the covariance.}
\item{codedata}{list of formula, name of the object \code{Glist}, number of friends in the network and name of the object \code{data}.}
}
\description{
Summary and print methods for the class \code{CDnetNPL} as returned by the function \link{CDnetNPL}.
}
